/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observers.Subscribers;
import rx.operators.NotificationLite;
import rx.subscriptions.Subscriptions;

public class BufferUntilSubscriber<T>
extends Observable<T>
implements Observer<T> {
    final State<T> state;

    public static <T> BufferUntilSubscriber<T> create() {
        State state = new State();
        return new BufferUntilSubscriber(state);
    }

    private BufferUntilSubscriber(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
    }

    @Override
    public void onCompleted() {
        this.state.observerRef.get().onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.state.observerRef.get().onError(e);
    }

    @Override
    public void onNext(T t) {
        this.state.observerRef.get().onNext(t);
    }

    private static class BufferedObserver<T>
    extends Subscriber<T> {
        private final ConcurrentLinkedQueue<Object> buffer = new ConcurrentLinkedQueue();
        private final NotificationLite<T> nl = NotificationLite.instance();

        private BufferedObserver() {
        }

        @Override
        public void onCompleted() {
            this.buffer.add(this.nl.completed());
        }

        @Override
        public void onError(Throwable e) {
            this.buffer.add(this.nl.error(e));
        }

        @Override
        public void onNext(T t) {
            this.buffer.add(this.nl.next(t));
        }
    }

    private static class PassThruObserver<T>
    extends Subscriber<T> {
        private final Observer<? super T> actual;
        private final ConcurrentLinkedQueue<Object> buffer;
        private final AtomicReference<Observer<? super T>> observerRef;
        private final NotificationLite<T> nl = NotificationLite.instance();

        PassThruObserver(Observer<? super T> actual, ConcurrentLinkedQueue<Object> buffer, AtomicReference<Observer<? super T>> observerRef) {
            this.actual = actual;
            this.buffer = buffer;
            this.observerRef = observerRef;
        }

        @Override
        public void onCompleted() {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onNext(t);
        }

        private void drainIfNeededAndSwitchToActual() {
            Object o;
            while ((o = this.buffer.poll()) != null) {
                this.nl.accept(this, o);
            }
            this.observerRef.compareAndSet(this, this.actual);
        }
    }

    static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        @Override
        public void call(Subscriber<? super T> s) {
            if (this.state.first.compareAndSet(false, true)) {
                Object o;
                BufferedObserver buffered = (BufferedObserver)this.state.observerRef.get();
                while ((o = buffered.buffer.poll()) != null) {
                    this.state.nl.accept(s, o);
                }
                this.state.observerRef.set(new PassThruObserver(s, buffered.buffer, this.state.observerRef));
                s.add(Subscriptions.create(new Action0(){

                    @Override
                    public void call() {
                        OnSubscribeAction.this.state.observerRef.set(Subscribers.empty());
                    }
                }));
            } else {
                s.onError(new IllegalStateException("Only one subscriber allowed!"));
            }
        }
    }

    static final class State<T> {
        final NotificationLite<T> nl = NotificationLite.instance();
        final AtomicReference<Observer<? super T>> observerRef = new AtomicReference(new BufferedObserver());
        final AtomicBoolean first = new AtomicBoolean();

        State() {
        }
    }
}

