/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.io.Serializable;
import rx.Notification;
import rx.Observer;

public final class NotificationLite<T> {
    private static final NotificationLite INSTANCE = new NotificationLite();
    private static final Object ON_COMPLETED_SENTINEL = new Serializable(){
        private static final long serialVersionUID = 1L;
    };
    private static final Object ON_NEXT_NULL_SENTINEL = new Serializable(){
        private static final long serialVersionUID = 2L;
    };

    private NotificationLite() {
    }

    public static <T> NotificationLite<T> instance() {
        return INSTANCE;
    }

    public Object next(T t) {
        if (t == null) {
            return ON_NEXT_NULL_SENTINEL;
        }
        return t;
    }

    public Object completed() {
        return ON_COMPLETED_SENTINEL;
    }

    public Object error(Throwable e) {
        return new OnErrorSentinel(e);
    }

    public void accept(Observer<? super T> o, Object n) {
        switch (this.kind(n)) {
            case OnNext: {
                o.onNext(this.getValue(n));
                break;
            }
            case OnCompleted: {
                o.onCompleted();
                break;
            }
            case OnError: {
                o.onError(this.getError(n));
            }
        }
    }

    public boolean isCompleted(Object n) {
        return n == ON_COMPLETED_SENTINEL;
    }

    public boolean isError(Object n) {
        return n instanceof OnErrorSentinel;
    }

    public Notification.Kind kind(Object n) {
        if (n == null) {
            throw new IllegalArgumentException("The lite notification can not be null");
        }
        if (n == ON_COMPLETED_SENTINEL) {
            return Notification.Kind.OnCompleted;
        }
        if (n instanceof OnErrorSentinel) {
            return Notification.Kind.OnError;
        }
        return Notification.Kind.OnNext;
    }

    public T getValue(Object n) {
        return (T)(n == ON_NEXT_NULL_SENTINEL ? null : n);
    }

    public Throwable getError(Object n) {
        return ((OnErrorSentinel)n).e;
    }

    private static class OnErrorSentinel
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final Throwable e;

        public OnErrorSentinel(Throwable e) {
            this.e = e;
        }
    }
}

