/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public final class OperatorBufferWithSize<T>
implements Observable.Operator<List<T>, T> {
    final int count;
    final int skip;

    public OperatorBufferWithSize(int count, int skip) {
        this.count = count;
        this.skip = skip;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> child) {
        if (this.count == this.skip) {
            return new Subscriber<T>(child){
                List<T> buffer;

                @Override
                public void onNext(T t) {
                    if (this.buffer == null) {
                        this.buffer = new ArrayList(OperatorBufferWithSize.this.count);
                    }
                    this.buffer.add(t);
                    if (this.buffer.size() == OperatorBufferWithSize.this.count) {
                        List oldBuffer = this.buffer;
                        this.buffer = null;
                        child.onNext(oldBuffer);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    this.buffer = null;
                    child.onError(e);
                }

                @Override
                public void onCompleted() {
                    List oldBuffer = this.buffer;
                    this.buffer = null;
                    if (oldBuffer != null) {
                        try {
                            child.onNext(oldBuffer);
                        }
                        catch (Throwable t) {
                            this.onError(t);
                            return;
                        }
                    }
                    child.onCompleted();
                }
            };
        }
        return new Subscriber<T>(child){
            final List<List<T>> chunks;
            int index;
            {
                super(x0);
                this.chunks = new LinkedList();
            }

            @Override
            public void onNext(T t) {
                if (this.index++ % OperatorBufferWithSize.this.skip == 0) {
                    this.chunks.add(new ArrayList(OperatorBufferWithSize.this.count));
                }
                Iterator it = this.chunks.iterator();
                while (it.hasNext()) {
                    List chunk = it.next();
                    chunk.add(t);
                    if (chunk.size() != OperatorBufferWithSize.this.count) continue;
                    it.remove();
                    child.onNext(chunk);
                }
            }

            @Override
            public void onError(Throwable e) {
                this.chunks.clear();
                child.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    for (List chunk : this.chunks) {
                        try {
                            child.onNext(chunk);
                        }
                        catch (Throwable t) {
                            this.onError(t);
                            this.chunks.clear();
                            return;
                        }
                    }
                    child.onCompleted();
                }
                finally {
                    this.chunks.clear();
                }
            }
        };
    }
}

