/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.FuncN;
import rx.observers.SerializedSubscriber;

public final class OperatorCombineLatest<T, R>
implements Observable.OnSubscribe<R> {
    final List<? extends Observable<? extends T>> sources;
    final FuncN<? extends R> combinator;

    public OperatorCombineLatest(List<? extends Observable<? extends T>> sources, FuncN<? extends R> combinator) {
        this.sources = sources;
        this.combinator = combinator;
    }

    @Override
    public void call(final Subscriber<? super R> child) {
        int i;
        if (this.sources.isEmpty()) {
            child.onCompleted();
            return;
        }
        if (this.sources.size() == 1) {
            this.sources.get(0).unsafeSubscribe(new Subscriber<T>(child){

                @Override
                public void onNext(T t) {
                    child.onNext(OperatorCombineLatest.this.combinator.call(t));
                }

                @Override
                public void onError(Throwable e) {
                    child.onError(e);
                }

                @Override
                public void onCompleted() {
                    child.onCompleted();
                }
            });
            return;
        }
        SerializedSubscriber<? super R> s = new SerializedSubscriber<R>(child);
        ArrayList<SourceSubscriber> sourceSubscribers = new ArrayList<SourceSubscriber>(this.sources.size());
        Collector collector = new Collector(s, this.sources.size());
        for (i = 0; i < this.sources.size(); ++i) {
            SourceSubscriber sourceSub = new SourceSubscriber(i, collector);
            child.add(sourceSub);
            sourceSubscribers.add(sourceSub);
        }
        for (i = 0; i < this.sources.size(); ++i) {
            if (child.isUnsubscribed()) continue;
            this.sources.get(i).unsafeSubscribe((Subscriber)sourceSubscribers.get(i));
        }
    }

    final class SourceSubscriber
    extends Subscriber<T> {
        final int index;
        final Collector collector;
        private boolean hasValue;

        public SourceSubscriber(int index, Collector collector) {
            this.index = index;
            this.collector = collector;
        }

        @Override
        public void onNext(T t) {
            this.hasValue = true;
            this.collector.next(this.index, t);
        }

        @Override
        public void onError(Throwable e) {
            this.collector.error(e);
        }

        @Override
        public void onCompleted() {
            this.collector.complete(this.index, this.hasValue);
        }
    }

    final class Collector {
        final Subscriber<R> s;
        Object[] collectedValues;
        final BitSet haveValues;
        int haveValuesCount;
        final BitSet completion;
        int completionCount;
        boolean emitting;
        List<Object[]> queue;

        public Collector(Subscriber<R> s, int size) {
            this.s = s;
            int n = size;
            this.collectedValues = new Object[n];
            this.haveValues = new BitSet(n);
            this.completion = new BitSet(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void next(int index, T value) {
            List<Object[]> localQueue;
            Object[] localValues;
            Collector collector = this;
            synchronized (collector) {
                if (!this.haveValues.get(index)) {
                    this.haveValues.set(index);
                    ++this.haveValuesCount;
                }
                this.collectedValues[index] = value;
                if (this.haveValuesCount != this.collectedValues.length) {
                    return;
                }
                localValues = (Object[])this.collectedValues.clone();
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new LinkedList<Object[]>();
                    }
                    this.queue.add(localValues);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    try {
                        if (localQueue != null) {
                            for (Object[] o : localQueue) {
                                this.s.onNext(OperatorCombineLatest.this.combinator.call(o));
                            }
                        }
                        if (once) {
                            once = false;
                            this.s.onNext(OperatorCombineLatest.this.combinator.call(localValues));
                        }
                    }
                    catch (Throwable e) {
                        this.error(e);
                        if (skipFinal) return;
                        Collector collector2 = this;
                        synchronized (collector2) {
                            this.emitting = false;
                            return;
                        }
                    }
                    Collector collector3 = this;
                    synchronized (collector3) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            skipFinal = true;
                            this.emitting = false;
                            return;
                        }
                    }
                } while (!this.s.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Collector collector4 = this;
                    synchronized (collector4) {
                        this.emitting = false;
                    }
                }
            }
        }

        void error(Throwable e) {
            this.s.onError(e);
            this.s.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(int index, boolean hadValue) {
            if (!hadValue) {
                this.s.onCompleted();
                this.s.unsubscribe();
                return;
            }
            boolean done = false;
            Collector collector = this;
            synchronized (collector) {
                if (!this.completion.get(index)) {
                    this.completion.set(index);
                    ++this.completionCount;
                    done = this.completionCount == this.collectedValues.length;
                }
            }
            if (done) {
                this.s.onCompleted();
            }
        }
    }
}

