/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;

public final class OperatorDelay<T>
implements Observable.OnSubscribe<T> {
    final Observable<? extends T> source;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorDelay(Observable<? extends T> source, long delay, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        Observable.concat(this.source.map(new Func1<T, Observable<T>>(){

            @Override
            public Observable<T> call(T x) {
                Emitter e = new Emitter(x);
                worker.schedule(e, OperatorDelay.this.delay, OperatorDelay.this.unit);
                return Observable.create(e);
            }
        })).subscribe(child);
    }

    public static final class Emitter<T>
    implements Observable.OnSubscribe<T>,
    Action0 {
        final T value;
        final Object guard;
        Subscriber<? super T> child;
        boolean done;

        public Emitter(T value) {
            this.value = value;
            this.guard = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(Subscriber<? super T> s) {
            Object object = this.guard;
            synchronized (object) {
                if (!this.done) {
                    this.child = s;
                    return;
                }
            }
            s.onNext(this.value);
            s.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call() {
            Subscriber<T> s;
            Object object = this.guard;
            synchronized (object) {
                this.done = true;
                s = this.child;
                this.child = null;
            }
            if (s != null) {
                s.onNext(this.value);
                s.onCompleted();
            }
        }
    }
}

