/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.operators.BufferUntilSubscriber;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public final class OperatorGroupBy<K, T>
implements Observable.Operator<GroupedObservable<K, T>, T> {
    final Func1<? super T, ? extends K> keySelector;

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector) {
        this.keySelector = keySelector;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super GroupedObservable<K, T>> childObserver) {
        return new Subscriber<T>(new CompositeSubscription()){
            private final Map<K, BufferUntilSubscriber<T>> groups;
            private final AtomicInteger completionCounter;
            private final AtomicBoolean completionEmitted;
            private final AtomicBoolean terminated;
            {
                super(x0);
                this.groups = new HashMap();
                this.completionCounter = new AtomicInteger(0);
                this.completionEmitted = new AtomicBoolean(false);
                this.terminated = new AtomicBoolean(false);
            }

            @Override
            public void onCompleted() {
                if (this.terminated.compareAndSet(false, true)) {
                    for (BufferUntilSubscriber ps : this.groups.values()) {
                        ps.onCompleted();
                    }
                    if (this.completionCounter.get() == 0 && this.completionEmitted.compareAndSet(false, true)) {
                        childObserver.onCompleted();
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                if (this.terminated.compareAndSet(false, true)) {
                    childObserver.onError(e);
                }
            }

            @Override
            public void onNext(T t) {
                try {
                    Object key = OperatorGroupBy.this.keySelector.call(t);
                    BufferUntilSubscriber gps = this.groups.get(key);
                    if (gps == null) {
                        if (childObserver.isUnsubscribed()) {
                            return;
                        }
                        final BufferUntilSubscriber _gps = gps = BufferUntilSubscriber.create();
                        GroupedObservable go = new GroupedObservable(key, new Observable.OnSubscribe<T>(){

                            @Override
                            public void call(final Subscriber<? super T> o) {
                                completionCounter.incrementAndGet();
                                o.add(Subscriptions.create(new Action0(){

                                    @Override
                                    public void call() {
                                        this.completeInner();
                                    }
                                }));
                                _gps.unsafeSubscribe(new Subscriber<T>(o){

                                    @Override
                                    public void onCompleted() {
                                        o.onCompleted();
                                        this.completeInner();
                                    }

                                    @Override
                                    public void onError(Throwable e) {
                                        o.onError(e);
                                    }

                                    @Override
                                    public void onNext(T t) {
                                        o.onNext(t);
                                    }
                                });
                            }
                        });
                        this.groups.put(key, gps);
                        childObserver.onNext(go);
                    }
                    gps.onNext(t);
                }
                catch (Throwable e) {
                    this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                }
            }

            private void completeInner() {
                if (this.completionCounter.decrementAndGet() <= 0 && (this.terminated.get() || childObserver.isUnsubscribed()) && this.completionEmitted.compareAndSet(false, true)) {
                    if (childObserver.isUnsubscribed()) {
                        this.unsubscribe();
                    }
                    childObserver.onCompleted();
                }
            }
        };
    }
}

