/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMergeDelayError<T>
implements Observable.Operator<T, Observable<? extends T>> {
    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        final AtomicInteger wip = new AtomicInteger(1);
        final ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        return new Subscriber<Observable<? extends T>>(){

            @Override
            public void onNext(Observable<? extends T> t) {
                wip.incrementAndGet();
                Subscriber itemSub = new Subscriber<T>(){
                    boolean once = true;

                    @Override
                    public void onNext(T t) {
                        if (this.once) {
                            try {
                                s.onNext(t);
                            }
                            catch (Throwable e) {
                                this.onError(e);
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (this.once) {
                            this.once = false;
                            this.error(e);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted() {
                        if (this.once) {
                            this.once = false;
                            try {
                                this.complete();
                            }
                            finally {
                                csub.remove(this);
                            }
                        }
                    }
                };
                csub.add(itemSub);
                t.unsafeSubscribe(itemSub);
            }

            @Override
            public void onError(Throwable e) {
                this.error(e);
            }

            @Override
            public void onCompleted() {
                this.complete();
            }

            void error(Throwable e) {
                exceptions.add(e);
                this.complete();
            }

            void complete() {
                if (wip.decrementAndGet() == 0) {
                    if (exceptions.isEmpty()) {
                        s.onCompleted();
                    } else if (exceptions.size() > 1) {
                        s.onError(new CompositeException(exceptions));
                    } else {
                        s.onError((Throwable)exceptions.peek());
                    }
                    exceptions.clear();
                    this.unsubscribe();
                }
            }
        };
    }
}

