/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMergeMapTransform<T, R>
implements Observable.Operator<R, T> {
    final Func1<? super T, ? extends Observable<? extends R>> onNext;
    final Func1<? super Throwable, ? extends Observable<? extends R>> onError;
    final Func0<? extends Observable<? extends R>> onCompleted;

    public OperatorMergeMapTransform(Func1<? super T, ? extends Observable<? extends R>> onNext, Func1<? super Throwable, ? extends Observable<? extends R>> onError, Func0<? extends Observable<? extends R>> onCompleted) {
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> child) {
        final SerializedSubscriber<? super R> s = new SerializedSubscriber<R>(child);
        final CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        return new Subscriber<T>(child){
            final AtomicInteger wip;
            {
                super(x0);
                this.wip = new AtomicInteger(1);
            }

            @Override
            public void onNext(T t) {
                Observable o;
                try {
                    o = OperatorMergeMapTransform.this.onNext.call(t);
                }
                catch (Throwable e) {
                    this.error(e);
                    return;
                }
                this.subscribeTo(o);
            }

            @Override
            public void onError(Throwable e) {
                Observable o;
                try {
                    o = OperatorMergeMapTransform.this.onError.call(e);
                }
                catch (Throwable t) {
                    this.error(t);
                    return;
                }
                this.subscribeTo(o);
                this.finish();
            }

            @Override
            public void onCompleted() {
                Observable o;
                try {
                    o = OperatorMergeMapTransform.this.onCompleted.call();
                }
                catch (Throwable e) {
                    this.error(e);
                    return;
                }
                this.subscribeTo(o);
                this.finish();
            }

            void finish() {
                if (this.wip.decrementAndGet() == 0) {
                    s.onCompleted();
                }
            }

            void error(Throwable t) {
                s.onError(t);
                this.unsubscribe();
            }

            void subscribeTo(Observable<? extends R> o) {
                Subscriber oSub = new Subscriber<R>(){

                    @Override
                    public void onNext(R t) {
                        s.onNext(t);
                    }

                    @Override
                    public void onError(Throwable e) {
                        this.error(e);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted() {
                        try {
                            this.finish();
                        }
                        finally {
                            csub.remove(this);
                        }
                    }
                };
                csub.add(oSub);
                this.wip.incrementAndGet();
                o.unsafeSubscribe(oSub);
            }
        };
    }
}

