/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMergeMaxConcurrent<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final int maxConcurrency;

    public OperatorMergeMaxConcurrent(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        return new Subscriber<Observable<? extends T>>(child){
            final Subscriber<?> self;
            final AtomicInteger wip;
            final Object guard;
            int active;
            Queue<Observable<? extends T>> queue;
            {
                super(x0);
                this.self = this;
                this.wip = new AtomicInteger(1);
                this.guard = new Object();
                this.queue = new LinkedList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(Observable<? extends T> t) {
                Object object = this.guard;
                synchronized (object) {
                    this.queue.add(t);
                }
                this.subscribeNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void subscribeNext() {
                Observable t;
                Object object = this.guard;
                synchronized (object) {
                    t = this.queue.peek();
                    if (t == null || this.active >= OperatorMergeMaxConcurrent.this.maxConcurrency) {
                        return;
                    }
                    ++this.active;
                    this.queue.poll();
                }
                this.wip.incrementAndGet();
                Subscriber itemSub = new Subscriber<T>(){
                    boolean once = true;

                    @Override
                    public void onNext(T t) {
                        s.onNext(t);
                    }

                    @Override
                    public void onError(Throwable e) {
                        self.onError(e);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted() {
                        if (this.once) {
                            this.once = false;
                            Object object = guard;
                            synchronized (object) {
                                --active;
                            }
                            csub.remove(this);
                            this.subscribeNext();
                            self.onCompleted();
                        }
                    }
                };
                csub.add(itemSub);
                t.unsafeSubscribe(itemSub);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
            }

            @Override
            public void onCompleted() {
                if (this.wip.decrementAndGet() == 0) {
                    s.onCompleted();
                }
            }
        };
    }
}

