/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.observables.ConnectableObservable;
import rx.subscriptions.Subscriptions;

public final class OperatorRefCount<T>
implements Observable.OnSubscribe<T> {
    final ConnectableObservable<? extends T> source;
    final Object guard;
    int index;
    boolean emitting;
    List<Token> queue;
    int count;
    Subscription connection;
    final Map<Token, Object> connectionStatus;
    private static final Object OCCUPIED = new Object();

    public OperatorRefCount(ConnectableObservable<? extends T> source) {
        this.source = source;
        this.guard = new Object();
        this.connectionStatus = new WeakHashMap<Token, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(Subscriber<? super T> t1) {
        int id;
        Object object = this.guard;
        synchronized (object) {
            id = ++this.index;
        }
        final Token t = new Token(id);
        t1.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                OperatorRefCount.this.disconnect(t);
            }
        }));
        this.source.unsafeSubscribe(t1);
        this.connect(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Token id) {
        List<Token> localQueue;
        Object object = this.guard;
        synchronized (object) {
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new ArrayList<Token>();
                }
                this.queue.add(id);
                return;
            }
            localQueue = this.queue;
            this.queue = null;
            this.emitting = true;
        }
        boolean once = true;
        while (true) {
            this.drain(localQueue);
            if (once) {
                once = false;
                this.doConnect(id);
            }
            Object object2 = this.guard;
            synchronized (object2) {
                localQueue = this.queue;
                this.queue = null;
                if (localQueue == null) {
                    this.emitting = false;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(Token id) {
        List<Token> localQueue;
        Object object = this.guard;
        synchronized (object) {
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new ArrayList<Token>();
                }
                this.queue.add(id.toDisconnect());
                return;
            }
            localQueue = this.queue;
            this.queue = null;
            this.emitting = true;
        }
        boolean once = true;
        while (true) {
            this.drain(localQueue);
            if (once) {
                once = false;
                this.doDisconnect(id);
            }
            Object object2 = this.guard;
            synchronized (object2) {
                localQueue = this.queue;
                this.queue = null;
                if (localQueue == null) {
                    this.emitting = false;
                    return;
                }
            }
        }
    }

    private void drain(List<Token> localQueue) {
        if (localQueue == null) {
            return;
        }
        int n = localQueue.size();
        for (int i = 0; i < n; ++i) {
            Token id = localQueue.get(i);
            if (id.isDisconnect()) {
                this.doDisconnect(id);
                continue;
            }
            this.doConnect(id);
        }
    }

    private void doConnect(Token id) {
        if (this.connectionStatus.put(id, OCCUPIED) == null) {
            if (this.count++ == 0) {
                this.connection = this.source.connect();
            }
        } else {
            this.connectionStatus.remove(id);
        }
    }

    private void doDisconnect(Token id) {
        if (this.connectionStatus.remove(id) != null) {
            if (--this.count == 0) {
                this.connection.unsubscribe();
                this.connection = null;
            }
        } else {
            this.connectionStatus.put(id, OCCUPIED);
        }
    }

    private static final class Token {
        final int id;

        public Token(int id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            int other = ((Token)obj).id;
            return this.id == other || -this.id == other;
        }

        public int hashCode() {
            return this.id < 0 ? -this.id : this.id;
        }

        public boolean isDisconnect() {
            return this.id < 0;
        }

        public Token toDisconnect() {
            if (this.id < 0) {
                return this;
            }
            return new Token(-this.id);
        }
    }
}

