/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observers.SerializedSubscriber;

public final class OperatorSampleWithTime<T>
implements Observable.Operator<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorSampleWithTime(long time, TimeUnit unit, Scheduler scheduler) {
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        SamplerSubscriber<? super T> sampler = new SamplerSubscriber<T>(s);
        worker.schedulePeriodically(sampler, this.time, this.time, this.unit);
        return sampler;
    }

    static final class SamplerSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        private final Subscriber<? super T> subscriber;
        private static final Object EMPTY_TOKEN = new Object();
        final AtomicReference<Object> value;

        public SamplerSubscriber(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            this.value = new AtomicReference<Object>(EMPTY_TOKEN);
        }

        @Override
        public void onNext(T t) {
            this.value.set(t);
        }

        @Override
        public void onError(Throwable e) {
            this.subscriber.onError(e);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            this.subscriber.onCompleted();
            this.unsubscribe();
        }

        @Override
        public void call() {
            Object localValue = this.value.getAndSet(EMPTY_TOKEN);
            if (localValue != EMPTY_TOKEN) {
                try {
                    Object v = localValue;
                    this.subscriber.onNext(v);
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }
        }
    }
}

