/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.NoSuchElementException;
import rx.Observable;
import rx.Subscriber;

public final class OperatorSingle<T>
implements Observable.Operator<T, T> {
    private final boolean hasDefaultValue;
    private final T defaultValue;

    public OperatorSingle() {
        this(false, null);
    }

    public OperatorSingle(T defaultValue) {
        this(true, defaultValue);
    }

    private OperatorSingle(boolean hasDefaultValue, T defaultValue) {
        this.hasDefaultValue = hasDefaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private T value;
            private boolean isNonEmpty;
            private boolean hasTooManyElements;
            {
                super(x0);
                this.isNonEmpty = false;
                this.hasTooManyElements = false;
            }

            @Override
            public void onNext(T value) {
                if (this.isNonEmpty) {
                    this.hasTooManyElements = true;
                    subscriber.onError(new IllegalArgumentException("Sequence contains too many elements"));
                } else {
                    this.value = value;
                    this.isNonEmpty = true;
                }
            }

            @Override
            public void onCompleted() {
                if (!this.hasTooManyElements) {
                    if (this.isNonEmpty) {
                        subscriber.onNext(this.value);
                        subscriber.onCompleted();
                    } else if (OperatorSingle.this.hasDefaultValue) {
                        subscriber.onNext(OperatorSingle.this.defaultValue);
                        subscriber.onCompleted();
                    } else {
                        subscriber.onError(new NoSuchElementException("Sequence contains no elements"));
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }
        };
    }
}

