/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;

public final class OperatorSkipWhile<T>
implements Observable.Operator<T, T> {
    private final Func2<? super T, Integer, Boolean> predicate;

    public OperatorSkipWhile(Func2<? super T, Integer, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            boolean skipping;
            int index;
            {
                super(x0);
                this.skipping = true;
            }

            @Override
            public void onNext(T t) {
                if (!this.skipping) {
                    child.onNext(t);
                } else if (!((Boolean)OperatorSkipWhile.this.predicate.call(t, this.index++)).booleanValue()) {
                    this.skipping = false;
                    child.onNext(t);
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
    }

    public static <T> Func2<T, Integer, Boolean> toPredicate2(final Func1<? super T, Boolean> predicate) {
        return new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T t1, Integer t2) {
                return (Boolean)predicate.call(t1);
            }
        };
    }
}

