/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedSubscriber;
import rx.operators.NotificationLite;
import rx.subscriptions.SerialSubscription;

public final class OperatorSwitch<T>
implements Observable.Operator<T, Observable<? extends T>> {
    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final SerialSubscription ssub = new SerialSubscription();
        child.add(ssub);
        return new Subscriber<Observable<? extends T>>(child){
            final Object guard;
            final Subscriber<?> self;
            final NotificationLite<?> nl;
            int index;
            boolean active;
            boolean mainDone;
            List<Object> queue;
            boolean emitting;
            {
                super(x0);
                this.guard = new Object();
                this.self = this;
                this.nl = NotificationLite.instance();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(Observable<? extends T> t) {
                int id;
                Object object = this.guard;
                synchronized (object) {
                    id = ++this.index;
                    this.active = true;
                }
                Subscriber sub = new Subscriber<T>(){

                    @Override
                    public void onNext(T t) {
                        this.emit(t, id);
                    }

                    @Override
                    public void onError(Throwable e) {
                        this.error(e, id);
                    }

                    @Override
                    public void onCompleted() {
                        this.complete(id);
                    }
                };
                ssub.set(sub);
                t.unsafeSubscribe(sub);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                List<Object> localQueue;
                Object object = this.guard;
                synchronized (object) {
                    this.mainDone = true;
                    if (this.active) {
                        return;
                    }
                    if (this.emitting) {
                        if (this.queue == null) {
                            this.queue = new ArrayList<Object>();
                        }
                        this.queue.add(this.nl.completed());
                        return;
                    }
                    localQueue = this.queue;
                    this.queue = null;
                    this.emitting = true;
                }
                this.drain(localQueue);
                s.onCompleted();
                this.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void emit(T value, int id) {
                Object object;
                List<Object> localQueue;
                Object object2 = this.guard;
                synchronized (object2) {
                    if (id != this.index) {
                        return;
                    }
                    if (this.emitting) {
                        if (this.queue == null) {
                            this.queue = new ArrayList<Object>();
                        }
                        this.queue.add(value);
                        return;
                    }
                    localQueue = this.queue;
                    this.queue = null;
                    this.emitting = true;
                }
                boolean once = true;
                boolean skipFinal = false;
                try {
                    do {
                        this.drain(localQueue);
                        if (once) {
                            once = false;
                            s.onNext(value);
                        }
                        object = this.guard;
                        synchronized (object) {
                            localQueue = this.queue;
                            this.queue = null;
                            if (localQueue == null) {
                                this.emitting = false;
                                skipFinal = true;
                                break;
                            }
                        }
                    } while (!s.isUnsubscribed());
                }
                finally {
                    if (!skipFinal) {
                        object = this.guard;
                        synchronized (object) {
                            this.emitting = false;
                        }
                    }
                }
            }

            void drain(List<Object> localQueue) {
                if (localQueue == null) {
                    return;
                }
                for (Object o : localQueue) {
                    if (this.nl.isCompleted(o)) {
                        s.onCompleted();
                        break;
                    }
                    if (this.nl.isError(o)) {
                        s.onError(this.nl.getError(o));
                        break;
                    }
                    Object t = o;
                    s.onNext(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void error(Throwable e, int id) {
                List<Object> localQueue;
                Object object = this.guard;
                synchronized (object) {
                    if (id != this.index) {
                        return;
                    }
                    if (this.emitting) {
                        if (this.queue == null) {
                            this.queue = new ArrayList<Object>();
                        }
                        this.queue.add(this.nl.error(e));
                        return;
                    }
                    localQueue = this.queue;
                    this.queue = null;
                    this.emitting = true;
                }
                this.drain(localQueue);
                s.onError(e);
                this.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void complete(int id) {
                List<Object> localQueue;
                Object object = this.guard;
                synchronized (object) {
                    if (id != this.index) {
                        return;
                    }
                    this.active = false;
                    if (!this.mainDone) {
                        return;
                    }
                    if (this.emitting) {
                        if (this.queue == null) {
                            this.queue = new ArrayList<Object>();
                        }
                        this.queue.add(this.nl.completed());
                        return;
                    }
                    localQueue = this.queue;
                    this.queue = null;
                    this.emitting = true;
                }
                this.drain(localQueue);
                s.onCompleted();
                this.unsubscribe();
            }
        };
    }
}

