/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorTake<T>
implements Observable.Operator<T, T> {
    final int limit;

    public OperatorTake(int limit) {
        this.limit = limit;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        CompositeSubscription parent = new CompositeSubscription();
        if (this.limit == 0) {
            child.onCompleted();
            parent.unsubscribe();
        }
        child.add(parent);
        return new Subscriber<T>(parent){
            int count;
            boolean completed;
            {
                super(x0);
                this.count = 0;
                this.completed = false;
            }

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    child.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.completed) {
                    child.onError(e);
                }
            }

            @Override
            public void onNext(T i) {
                if (!this.isUnsubscribed()) {
                    child.onNext(i);
                    if (++this.count >= OperatorTake.this.limit) {
                        this.completed = true;
                        child.onCompleted();
                        this.unsubscribe();
                    }
                }
            }
        };
    }
}

