/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Timestamped;

public final class OperatorTakeLastTimed<T>
implements Observable.Operator<T, T> {
    private final long ageMillis;
    private final Scheduler scheduler;
    private final int count;

    public OperatorTakeLastTimed(long time, TimeUnit unit, Scheduler scheduler) {
        this.ageMillis = unit.toMillis(time);
        this.scheduler = scheduler;
        this.count = -1;
    }

    public OperatorTakeLastTimed(int count, long time, TimeUnit unit, Scheduler scheduler) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.ageMillis = unit.toMillis(time);
        this.scheduler = scheduler;
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private final Deque<Timestamped<T>> buffer;
            {
                super(x0);
                this.buffer = new ArrayDeque();
            }

            protected void runEvictionPolicy(long now) {
                Timestamped v;
                while (OperatorTakeLastTimed.this.count >= 0 && this.buffer.size() > OperatorTakeLastTimed.this.count) {
                    this.buffer.pollFirst();
                }
                while (!this.buffer.isEmpty() && (v = this.buffer.peekFirst()).getTimestampMillis() < now - OperatorTakeLastTimed.this.ageMillis) {
                    this.buffer.pollFirst();
                }
            }

            @Override
            public void onNext(T args) {
                long t = OperatorTakeLastTimed.this.scheduler.now();
                this.buffer.add(new Timestamped(t, args));
                this.runEvictionPolicy(t);
            }

            @Override
            public void onError(Throwable e) {
                this.buffer.clear();
                subscriber.onError(e);
            }

            @Override
            public void onCompleted() {
                this.runEvictionPolicy(OperatorTakeLastTimed.this.scheduler.now());
                try {
                    for (Timestamped v : this.buffer) {
                        subscriber.onNext(v.getValue());
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                this.buffer.clear();
                subscriber.onCompleted();
            }
        };
    }
}

