/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.operators.NotificationLite;

public final class OperatorTakeUntil {
    public static <T, E> Observable<T> takeUntil(Observable<? extends T> source, Observable<? extends E> other) {
        Observable s = source.lift(new SourceObservable());
        Observable o = other.lift(new OtherObservable());
        Observable result = Observable.merge(s, o);
        final NotificationLite notification = NotificationLite.instance();
        return result.takeWhile(new Func1<Object, Boolean>(){

            @Override
            public Boolean call(Object args) {
                return !notification.isCompleted(args);
            }
        }).map(new Func1<Object, T>(){

            @Override
            public T call(Object args) {
                return notification.getValue(args);
            }
        });
    }

    private static final class OtherObservable<E>
    implements Observable.Operator<Object, E> {
        private final NotificationLite<E> notification = NotificationLite.instance();

        private OtherObservable() {
        }

        @Override
        public Subscriber<? super E> call(final Subscriber<? super Object> subscriber) {
            return new Subscriber<E>(subscriber){

                @Override
                public void onCompleted() {
                    subscriber.onNext(OtherObservable.this.notification.completed());
                }

                @Override
                public void onError(Throwable e) {
                    subscriber.onError(e);
                }

                @Override
                public void onNext(E args) {
                    subscriber.onNext(OtherObservable.this.notification.completed());
                }
            };
        }
    }

    private static final class SourceObservable<T>
    implements Observable.Operator<Object, T> {
        private final NotificationLite<T> notification = NotificationLite.instance();

        private SourceObservable() {
        }

        @Override
        public Subscriber<? super T> call(final Subscriber<? super Object> subscriber) {
            return new Subscriber<T>(subscriber){

                @Override
                public void onCompleted() {
                    subscriber.onNext(SourceObservable.this.notification.completed());
                }

                @Override
                public void onError(Throwable e) {
                    subscriber.onError(e);
                }

                @Override
                public void onNext(T args) {
                    subscriber.onNext(SourceObservable.this.notification.next(args));
                }
            };
        }
    }
}

