/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;

public final class OperatorTakeWhile<T>
implements Observable.Operator<T, T> {
    private final Func2<? super T, ? super Integer, Boolean> predicate;

    public OperatorTakeWhile(final Func1<? super T, Boolean> underlying) {
        this(new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T input, Integer index) {
                return (Boolean)underlying.call(input);
            }
        });
    }

    public OperatorTakeWhile(Func2<? super T, ? super Integer, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private int counter;
            {
                super(x0);
                this.counter = 0;
            }

            @Override
            public void onNext(T args) {
                boolean isSelected;
                try {
                    isSelected = (Boolean)OperatorTakeWhile.this.predicate.call(args, this.counter++);
                }
                catch (Throwable e) {
                    subscriber.onError(e);
                    this.unsubscribe();
                    return;
                }
                if (isSelected) {
                    subscriber.onNext(args);
                } else {
                    subscriber.onCompleted();
                    this.unsubscribe();
                }
            }

            @Override
            public void onCompleted() {
                subscriber.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }
        };
    }
}

