/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.NewThreadScheduler;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

class EventLoopsScheduler
extends Scheduler {
    EventLoopsScheduler() {
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new EventLoop();
    }

    private static class EventLoopScheduler
    extends NewThreadScheduler.EventLoopScheduler {
        EventLoopScheduler(ThreadFactory threadFactory) {
            super(threadFactory);
        }
    }

    private static class EventLoop
    extends Scheduler.Worker {
        private final CompositeSubscription innerSubscription = new CompositeSubscription();
        private final EventLoopScheduler pooledEventLoop = ComputationSchedulerPool.access$000().getEventLoop();
        private final NewThreadScheduler.OnActionComplete onComplete = new NewThreadScheduler.OnActionComplete(){

            @Override
            public void complete(Subscription s) {
                EventLoop.this.innerSubscription.remove(s);
            }
        };

        EventLoop() {
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }

        @Override
        public Subscription schedule(Action0 action) {
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            return this.pooledEventLoop.schedule(action, this.onComplete);
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            return this.pooledEventLoop.schedule(action, delayTime, unit, this.onComplete);
        }
    }

    private static class ComputationSchedulerPool {
        final int cores = Runtime.getRuntime().availableProcessors();
        final ThreadFactory factory = new ThreadFactory(){
            final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "RxComputationThreadPool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        };
        final EventLoopScheduler[] eventLoops = new EventLoopScheduler[this.cores];
        private static ComputationSchedulerPool INSTANCE = new ComputationSchedulerPool();
        long n = 0L;

        ComputationSchedulerPool() {
            for (int i = 0; i < this.cores; ++i) {
                this.eventLoops[i] = new EventLoopScheduler(this.factory);
            }
        }

        public EventLoopScheduler getEventLoop() {
            return this.eventLoops[(int)(this.n++ % (long)this.cores)];
        }

        static /* synthetic */ ComputationSchedulerPool access$000() {
            return INSTANCE;
        }
    }
}

