/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class NewThreadScheduler
extends Scheduler {
    private static final NewThreadScheduler INSTANCE = new NewThreadScheduler();
    private static final AtomicLong count = new AtomicLong();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "RxNewThreadScheduler-" + count.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    };

    static NewThreadScheduler instance() {
        return INSTANCE;
    }

    private NewThreadScheduler() {
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new EventLoopScheduler(THREAD_FACTORY);
    }

    static interface OnActionComplete {
        public void complete(Subscription var1);
    }

    static class EventLoopScheduler
    extends Scheduler.Worker
    implements Subscription {
        private final CompositeSubscription innerSubscription = new CompositeSubscription();
        private final ExecutorService executor;

        EventLoopScheduler(ThreadFactory threadFactory) {
            this.executor = Executors.newSingleThreadExecutor(threadFactory);
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.schedule(action, null);
        }

        Subscription schedule(final Action0 action, final OnActionComplete onComplete) {
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            final AtomicReference<Subscription> sf = new AtomicReference<Subscription>();
            Subscription s = Subscriptions.from(this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (EventLoopScheduler.this.innerSubscription.isUnsubscribed()) {
                            return;
                        }
                        action.call();
                    }
                    finally {
                        Subscription s = (Subscription)sf.get();
                        if (s != null) {
                            EventLoopScheduler.this.innerSubscription.remove(s);
                        }
                        if (onComplete != null) {
                            onComplete.complete(s);
                        }
                    }
                }
            }));
            sf.set(s);
            this.innerSubscription.add(s);
            return s;
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            return this.schedule(action, delayTime, unit, null);
        }

        Subscription schedule(final Action0 action, long delayTime, TimeUnit unit, final OnActionComplete onComplete) {
            final AtomicReference<Subscription> sf = new AtomicReference<Subscription>();
            ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (EventLoopScheduler.this.innerSubscription.isUnsubscribed()) {
                            return;
                        }
                        EventLoopScheduler.this.schedule(action);
                    }
                    finally {
                        Subscription s = (Subscription)sf.get();
                        if (s != null) {
                            EventLoopScheduler.this.innerSubscription.remove(s);
                        }
                        if (onComplete != null) {
                            onComplete.complete(s);
                        }
                    }
                }
            }, delayTime, unit);
            Subscription s = Subscriptions.from(f);
            sf.set(s);
            this.innerSubscription.add(s);
            return s;
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

