/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import rx.Scheduler;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.EventLoopsScheduler;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.NewThreadScheduler;
import rx.schedulers.TestScheduler;
import rx.schedulers.TrampolineScheduler;

public final class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final Schedulers INSTANCE = new Schedulers();

    private Schedulers() {
        Scheduler c = RxJavaPlugins.getInstance().getDefaultSchedulers().getComputationScheduler();
        this.computationScheduler = c != null ? c : new EventLoopsScheduler();
        Scheduler io = RxJavaPlugins.getInstance().getDefaultSchedulers().getIOScheduler();
        this.ioScheduler = io != null ? io : NewThreadScheduler.instance();
        Scheduler nt = RxJavaPlugins.getInstance().getDefaultSchedulers().getNewThreadScheduler();
        this.newThreadScheduler = nt != null ? nt : NewThreadScheduler.instance();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.instance();
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.instance();
    }

    public static Scheduler newThread() {
        return Schedulers.INSTANCE.newThreadScheduler;
    }

    public static Scheduler computation() {
        return Schedulers.INSTANCE.computationScheduler;
    }

    public static Scheduler io() {
        return Schedulers.INSTANCE.ioScheduler;
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }
}

