/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.SleepingAction;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.Subscriptions;

public class TrampolineScheduler
extends Scheduler {
    private static final TrampolineScheduler INSTANCE = new TrampolineScheduler();
    private static final ThreadLocal<PriorityQueue<TimedAction>> QUEUE = new ThreadLocal();
    private final AtomicInteger counter = new AtomicInteger(0);

    static TrampolineScheduler instance() {
        return INSTANCE;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new InnerCurrentThreadScheduler();
    }

    TrampolineScheduler() {
    }

    private static class TimedAction
    implements Comparable<TimedAction> {
        final Action0 action;
        final Long execTime;
        final Integer count;

        private TimedAction(Action0 action, Long execTime, Integer count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return this.count.compareTo(that.count);
            }
            return result;
        }
    }

    private class InnerCurrentThreadScheduler
    extends Scheduler.Worker
    implements Subscription {
        private final BooleanSubscription innerSubscription = new BooleanSubscription();

        private InnerCurrentThreadScheduler() {
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.enqueue(action, this.now());
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            long execTime = this.now() + unit.toMillis(delayTime);
            return this.enqueue(new SleepingAction(action, this, execTime), execTime);
        }

        private Subscription enqueue(Action0 action, long execTime) {
            boolean exec;
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            PriorityQueue<TimedAction> queue = (PriorityQueue<TimedAction>)QUEUE.get();
            boolean bl = exec = queue == null;
            if (exec) {
                queue = new PriorityQueue<TimedAction>();
                QUEUE.set(queue);
            }
            final TimedAction timedAction = new TimedAction(action, execTime, TrampolineScheduler.this.counter.incrementAndGet());
            queue.add(timedAction);
            if (exec) {
                while (!queue.isEmpty()) {
                    if (this.innerSubscription.isUnsubscribed()) {
                        return Subscriptions.empty();
                    }
                    ((TimedAction)queue.poll()).action.call();
                }
                QUEUE.set(null);
                return Subscriptions.empty();
            }
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    PriorityQueue _q = (PriorityQueue)QUEUE.get();
                    if (_q != null) {
                        _q.remove(timedAction);
                    }
                }
            });
        }

        @Override
        public void unsubscribe() {
            QUEUE.set(null);
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

