/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class ReplaySubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    private final ReplayState<T> state;

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int initialCapacity) {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final ReplayState state = new ReplayState(initialCapacity);
        Observable.OnSubscribe onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                int lastIndex = ReplaySubject.replayObserverFromIndex(state.history, 0, o);
                state.replayState.put(o, lastIndex);
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                Integer idx = state.replayState.remove(o);
                ReplaySubject.replayObserverFromIndex(state.history, idx, o);
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                state.replayState.remove(o);
            }
        });
        return new ReplaySubject(onSubscribe, subscriptionManager, state);
    }

    protected ReplaySubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, ReplayState<T> state) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.state = state;
    }

    @Override
    public void onCompleted() {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                ((ReplaySubject)ReplaySubject.this).state.history.complete();
            }
        });
        if (observers != null) {
            for (SubjectSubscriptionManager.SubjectObserver<T> o : observers) {
                if (!this.caughtUp(o)) continue;
                o.onCompleted();
            }
        }
    }

    @Override
    public void onError(final Throwable e) {
        Collection<SubjectSubscriptionManager.SubjectObserver<T>> observers = this.subscriptionManager.terminate(new Action0(){

            @Override
            public void call() {
                ((ReplaySubject)ReplaySubject.this).state.history.complete(e);
            }
        });
        if (observers != null) {
            for (SubjectSubscriptionManager.SubjectObserver<T> o : observers) {
                if (!this.caughtUp(o)) continue;
                o.onError(e);
            }
        }
    }

    @Override
    public void onNext(T v) {
        if (this.state.history.terminated) {
            return;
        }
        this.state.history.next(v);
        for (SubjectSubscriptionManager.SubjectObserver<Object> o : this.subscriptionManager.rawSnapshot()) {
            if (!this.caughtUp(o)) continue;
            o.onNext(v);
        }
    }

    private boolean caughtUp(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
        if (!o.caughtUp) {
            o.caughtUp = true;
            this.replayObserver(o);
            return false;
        }
        return true;
    }

    private void replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
        Integer lastEmittedLink = this.state.replayState.get(observer);
        if (lastEmittedLink == null) {
            throw new IllegalStateException("failed to find lastEmittedLink for: " + observer);
        }
        int l = ReplaySubject.replayObserverFromIndex(this.state.history, lastEmittedLink, observer);
        this.state.replayState.put(observer, l);
    }

    private static <T> int replayObserverFromIndex(History<T> history, Integer l, SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
        while (l < ((History)history).index.get()) {
            history.accept(observer, l);
            Integer n = l;
            Integer n2 = l = Integer.valueOf(l + 1);
        }
        return l;
    }

    int subscriberCount() {
        return this.state.replayState.size();
    }

    private static class History<T> {
        private final NotificationLite<T> nl = NotificationLite.instance();
        private final AtomicInteger index = new AtomicInteger(0);
        private final ArrayList<Object> list;
        private boolean terminated;

        public History(int initialCapacity) {
            this.list = new ArrayList(initialCapacity);
        }

        public boolean next(T n) {
            if (!this.terminated) {
                this.list.add(this.nl.next(n));
                this.index.getAndIncrement();
                return true;
            }
            return false;
        }

        public void accept(Observer<? super T> o, int idx) {
            this.nl.accept(o, this.list.get(idx));
        }

        public void complete() {
            if (!this.terminated) {
                this.terminated = true;
                this.list.add(this.nl.completed());
                this.index.getAndIncrement();
            }
        }

        public void complete(Throwable e) {
            if (!this.terminated) {
                this.terminated = true;
                this.list.add(this.nl.error(e));
                this.index.getAndIncrement();
            }
        }
    }

    private static class ReplayState<T> {
        final History<T> history;
        final ConcurrentHashMap<Observer<? super T>, Integer> replayState;

        public ReplayState(int initialCapacity) {
            this.history = new History(initialCapacity);
            this.replayState = new ConcurrentHashMap();
        }
    }
}

