/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.exceptions.CompositeException;

public final class CompositeSubscription
implements Subscription {
    private final AtomicReference<State> state = new AtomicReference();
    private static final State CLEAR_STATE;
    private static final State CLEAR_STATE_UNSUBSCRIBED;

    public CompositeSubscription() {
        this.state.set(CLEAR_STATE);
    }

    public CompositeSubscription(Subscription ... subscriptions) {
        this.state.set(new State(false, subscriptions));
    }

    @Override
    public boolean isUnsubscribed() {
        return this.state.get().isUnsubscribed;
    }

    public void add(Subscription s) {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            s.unsubscribe();
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.add(s)));
    }

    public void remove(Subscription s) {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.remove(s)));
        s.unsubscribe();
    }

    public void clear() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.clear()));
        CompositeSubscription.unsubscribeFromAll(oldState.subscriptions);
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.unsubscribe()));
        CompositeSubscription.unsubscribeFromAll(oldState.subscriptions);
    }

    private static void unsubscribeFromAll(Subscription[] subscriptions) {
        ArrayList<Throwable> es = new ArrayList<Throwable>();
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                es.add(e);
            }
        }
        if (!es.isEmpty()) {
            if (es.size() == 1) {
                Throwable t = (Throwable)es.get(0);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new CompositeException("Failed to unsubscribe to 1 or more subscriptions.", es);
            }
            throw new CompositeException("Failed to unsubscribe to 2 or more subscriptions.", es);
        }
    }

    static {
        Subscription[] s0 = new Subscription[]{};
        CLEAR_STATE = new State(false, s0);
        CLEAR_STATE_UNSUBSCRIBED = new State(true, s0);
    }

    private static final class State {
        final boolean isUnsubscribed;
        final Subscription[] subscriptions;

        State(boolean u, Subscription[] s) {
            this.isUnsubscribed = u;
            this.subscriptions = s;
        }

        State unsubscribe() {
            return CLEAR_STATE_UNSUBSCRIBED;
        }

        State add(Subscription s) {
            int idx = this.subscriptions.length;
            Subscription[] newSubscriptions = new Subscription[idx + 1];
            System.arraycopy(this.subscriptions, 0, newSubscriptions, 0, idx);
            newSubscriptions[idx] = s;
            return new State(this.isUnsubscribed, newSubscriptions);
        }

        State remove(Subscription s) {
            if (this.subscriptions.length == 1 && this.subscriptions[0].equals(s) || this.subscriptions.length == 0) {
                return this.clear();
            }
            Subscription[] newSubscriptions = new Subscription[this.subscriptions.length - 1];
            int idx = 0;
            for (Subscription _s : this.subscriptions) {
                if (_s.equals(s)) continue;
                if (idx == newSubscriptions.length) {
                    return this;
                }
                newSubscriptions[idx] = _s;
                ++idx;
            }
            if (idx == 0) {
                return this.clear();
            }
            if (idx < newSubscriptions.length) {
                Subscription[] newSub2 = new Subscription[idx];
                System.arraycopy(newSubscriptions, 0, newSub2, 0, idx);
                return new State(this.isUnsubscribed, newSub2);
            }
            return new State(this.isUnsubscribed, newSubscriptions);
        }

        State clear() {
            return this.isUnsubscribed ? CLEAR_STATE_UNSUBSCRIBED : CLEAR_STATE;
        }
    }
}

