/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.ConcatKDF;
import com.nimbusds.jose.crypto.ECDHCryptoProvider;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class ECDH {
    public static AlgorithmMode resolveAlgorithmMode(JWEAlgorithm alg) throws JOSEException {
        if (alg.equals(JWEAlgorithm.ECDH_ES)) {
            return AlgorithmMode.DIRECT;
        }
        if (alg.equals(JWEAlgorithm.ECDH_ES_A128KW) || alg.equals(JWEAlgorithm.ECDH_ES_A192KW) || alg.equals(JWEAlgorithm.ECDH_ES_A256KW)) {
            return AlgorithmMode.KW;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, ECDHCryptoProvider.SUPPORTED_ALGORITHMS));
    }

    public static int sharedKeyLength(JWEAlgorithm alg, EncryptionMethod enc) throws JOSEException {
        if (alg.equals(JWEAlgorithm.ECDH_ES)) {
            int length = enc.cekBitLength();
            if (length == 0) {
                throw new JOSEException("Unsupported JWE encryption method " + enc);
            }
            return length;
        }
        if (alg.equals(JWEAlgorithm.ECDH_ES_A128KW)) {
            return 128;
        }
        if (alg.equals(JWEAlgorithm.ECDH_ES_A192KW)) {
            return 192;
        }
        if (alg.equals(JWEAlgorithm.ECDH_ES_A256KW)) {
            return 256;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, ECDHCryptoProvider.SUPPORTED_ALGORITHMS));
    }

    public static SecretKey deriveSharedSecret(ECPublicKey publicKey, ECPrivateKey privateKey, Provider provider) throws JOSEException {
        KeyAgreement keyAgreement;
        try {
            keyAgreement = provider != null ? KeyAgreement.getInstance("ECDH", provider) : KeyAgreement.getInstance("ECDH");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Couldn't get an ECDH key agreement instance: " + e.getMessage(), e);
        }
        try {
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(publicKey, true);
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid key for ECDH key agreement: " + e.getMessage(), e);
        }
        return new SecretKeySpec(keyAgreement.generateSecret(), "AES");
    }

    public static SecretKey deriveSharedKey(JWEHeader header, SecretKey Z, ConcatKDF concatKDF) throws JOSEException {
        String algID;
        int sharedKeyLength = ECDH.sharedKeyLength(header.getAlgorithm(), header.getEncryptionMethod());
        AlgorithmMode algMode = ECDH.resolveAlgorithmMode(header.getAlgorithm());
        if (algMode == AlgorithmMode.DIRECT) {
            algID = header.getEncryptionMethod().getName();
        } else if (algMode == AlgorithmMode.KW) {
            algID = header.getAlgorithm().getName();
        } else {
            throw new JOSEException("Unsupported JWE ECDH algorithm mode: " + (Object)((Object)algMode));
        }
        return concatKDF.deriveKey(Z, sharedKeyLength, ConcatKDF.encodeDataWithLength(algID.getBytes(Charset.forName("ASCII"))), ConcatKDF.encodeDataWithLength(header.getAgreementPartyUInfo()), ConcatKDF.encodeDataWithLength(header.getAgreementPartyVInfo()), ConcatKDF.encodeIntData(sharedKeyLength), ConcatKDF.encodeNoData());
    }

    public static void ensurePointOnCurve(ECPublicKey ephemeralPublicKey, ECPrivateKey privateKey) throws JOSEException {
        BigInteger rightSide;
        ECParameterSpec ecParameterSpec = privateKey.getParams();
        EllipticCurve curve = ecParameterSpec.getCurve();
        ECPoint point = ephemeralPublicKey.getW();
        BigInteger x = point.getAffineX();
        BigInteger y = point.getAffineY();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        BigInteger p = ((ECFieldFp)curve.getField()).getP();
        BigInteger leftSide = y.pow(2).mod(p);
        if (!leftSide.equals(rightSide = x.pow(3).add(a.multiply(x)).add(b).mod(p))) {
            throw new JOSEException("Invalid ephemeral public key: Point not on expected curve");
        }
    }

    private ECDH() {
    }

    public static enum AlgorithmMode {
        DIRECT,
        KW;

    }
}

