/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.Immutable;

@Immutable
public class PKITLSClientAuthentication
extends TLSClientAuthentication {
    private final String certSubjectDN;

    public PKITLSClientAuthentication(ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID, sslSocketFactory);
        this.certSubjectDN = null;
    }

    public PKITLSClientAuthentication(ClientID clientID, String certSubjectDN) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID);
        if (certSubjectDN == null) {
            throw new IllegalArgumentException("The X.509 client certificate subject DN must not be null");
        }
        this.certSubjectDN = certSubjectDN;
    }

    public String getClientX509CertificateSubjectDN() {
        return this.certSubjectDN;
    }

    public static PKITLSClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, List<String>> params = URLUtils.parseParameters(query);
        String clientIDString = MultivaluedMapUtils.getFirstValue(params, "client_id");
        if (StringUtils.isBlank(clientIDString)) {
            throw new ParseException("Missing client_id parameter");
        }
        if (httpRequest.getClientX509CertificateSubjectDN() == null) {
            throw new ParseException("Missing client X.509 certificate subject DN");
        }
        return new PKITLSClientAuthentication(new ClientID(clientIDString), httpRequest.getClientX509CertificateSubjectDN());
    }
}

