/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.future;

public class StackTraceInspector {
    private static boolean exceptionInMethod(Throwable t, String className, String methodName) {
        try {
            for (StackTraceElement element : t.getStackTrace()) {
                if (!element.getClassName().equals(className) || !element.getMethodName().equals(methodName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean abortOnConnectCloseException(Throwable t) {
        return StackTraceInspector.exceptionInMethod(t, "sun.nio.ch.SocketChannelImpl", "checkConnect") || t.getCause() != null && StackTraceInspector.abortOnConnectCloseException(t.getCause());
    }

    public static boolean abortOnDisconnectException(Throwable t) {
        return StackTraceInspector.exceptionInMethod(t, "org.jboss.netty.handler.ssl.SslHandler", "channelDisconnected") || t.getCause() != null && StackTraceInspector.abortOnConnectCloseException(t.getCause());
    }

    public static boolean abortOnReadOrWriteException(Throwable t) {
        try {
            for (StackTraceElement element : t.getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (!className.equals("sun.nio.ch.SocketDispatcher") || !methodName.equals("read") && !methodName.equals("write")) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (t.getCause() != null) {
            return StackTraceInspector.abortOnReadOrWriteException(t.getCause());
        }
        return false;
    }
}

