/*
 * Decompiled with CFR 0.152.
 */
package com.pszymczyk.consul;

import com.pszymczyk.consul.ConsulLogHandler;
import com.pszymczyk.consul.ConsulPorts;
import com.pszymczyk.consul.ConsulProcess;
import com.pszymczyk.consul.CustomConfig;
import com.pszymczyk.consul.EmbeddedConsulException;
import com.pszymczyk.consul.LogLevel;
import com.pszymczyk.consul.infrastructure.AntUnzip;
import com.pszymczyk.consul.infrastructure.ConsulWaiter;
import com.pszymczyk.consul.infrastructure.HttpBinaryRepository;
import com.pszymczyk.consul.infrastructure.OsResolver;
import com.pszymczyk.consul.infrastructure.client.ConsulClientFactory;
import com.pszymczyk.consul.infrastructure.client.SimpleConsulClient;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulStarter
implements GroovyObject {
    private static final Logger logger;
    private static final Random random;
    private final Path dataDir;
    private final Path downloadDir;
    private final Path configDir;
    private final CustomConfig customConfig;
    private final String consulVersion;
    private final LogLevel logLevel;
    private final Logger customLogger;
    private final ConsulPorts consulPorts;
    private final String startJoin;
    private final String advertise;
    private final String client;
    private final String bind;
    private final String token;
    private final Integer waitTimeout;
    private final ConsulLogHandler logHandler;
    private boolean started;
    private HttpBinaryRepository binaryRepository;
    private AntUnzip unzip;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    ConsulStarter(Path path, Path path2, Path path3, String string, CustomConfig customConfig, LogLevel logLevel, Logger logger, ConsulPorts.ConsulPortsBuilder consulPortsBuilder, String string2, String string3, String string4, String string5, String string6, Integer n) {
        void waitTimeout;
        void token;
        void bind;
        void client;
        void advertise;
        void startJoin;
        void ports;
        void consulVersion;
        void downloadDir;
        void dataDir;
        void customConfig2;
        void configDir;
        void customLogger;
        void logLevel2;
        MetaClass metaClass;
        boolean bl;
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        this.started = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var18_18 = logLevel2;
        this.logLevel = (LogLevel)ShortTypeHandling.castToEnum((Object)var18_18, LogLevel.class);
        void var19_19 = customLogger;
        this.customLogger = (Logger)ScriptBytecodeAdapter.castToType((Object)var19_19, Logger.class);
        void var20_20 = configDir;
        this.configDir = (Path)ScriptBytecodeAdapter.castToType((Object)var20_20, Path.class);
        void var21_21 = customConfig2;
        this.customConfig = (CustomConfig)ScriptBytecodeAdapter.castToType((Object)var21_21, CustomConfig.class);
        void var22_22 = dataDir;
        this.dataDir = (Path)ScriptBytecodeAdapter.castToType((Object)var22_22, Path.class);
        void var23_23 = downloadDir;
        this.downloadDir = (Path)ScriptBytecodeAdapter.castToType((Object)var23_23, Path.class);
        void var24_24 = consulVersion;
        this.consulVersion = ShortTypeHandling.castToString((Object)var24_24);
        Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)ports);
        this.consulPorts = (ConsulPorts)ScriptBytecodeAdapter.castToType((Object)object, ConsulPorts.class);
        void var26_26 = startJoin;
        this.startJoin = ShortTypeHandling.castToString((Object)var26_26);
        void var27_27 = advertise;
        this.advertise = ShortTypeHandling.castToString((Object)var27_27);
        void var28_28 = client;
        this.client = ShortTypeHandling.castToString((Object)var28_28);
        void var29_29 = bind;
        this.bind = ShortTypeHandling.castToString((Object)var29_29);
        void var30_30 = token;
        this.token = ShortTypeHandling.castToString((Object)var30_30);
        void var31_31 = waitTimeout;
        this.waitTimeout = (Integer)ScriptBytecodeAdapter.castToType((Object)var31_31, Integer.class);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[1].callCurrent((GroovyObject)this);
        } else {
            this.makeDI();
        }
        Object object2 = callSiteArray[2].callConstructor(ConsulLogHandler.class, (Object)customLogger);
        this.logHandler = (ConsulLogHandler)ScriptBytecodeAdapter.castToType((Object)object2, ConsulLogHandler.class);
    }

    private ConsulPorts mergePorts(ConsulPorts.ConsulPortsBuilder ports) {
        Reference ports2 = new Reference((Object)ports);
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        Object extraPorts = callSiteArray[3].call((Object)this.customConfig, (Object)"ports");
        public class _mergePorts_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ports;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _mergePorts_closure1(Object _outerInstance, Object _thisObject, Reference ports) {
                Reference reference;
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ports = reference = ports;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(it);
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"dns")) {
                    Object object2 = callSiteArray[1].call(this.ports.get(), callSiteArray[2].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object2, ConsulPorts.ConsulPortsBuilder.class)));
                    return object2;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"http")) {
                    Object object3 = callSiteArray[3].call(this.ports.get(), callSiteArray[4].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object3, ConsulPorts.ConsulPortsBuilder.class)));
                    return object3;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"serf_lan")) {
                    Object object4 = callSiteArray[5].call(this.ports.get(), callSiteArray[6].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object4, ConsulPorts.ConsulPortsBuilder.class)));
                    return object4;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"serf_wan")) {
                    Object object5 = callSiteArray[7].call(this.ports.get(), callSiteArray[8].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object5, ConsulPorts.ConsulPortsBuilder.class)));
                    return object5;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"server")) {
                    Object object6 = callSiteArray[9].call(this.ports.get(), callSiteArray[10].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object6, ConsulPorts.ConsulPortsBuilder.class)));
                    return object6;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"grpc")) {
                    Object object7 = callSiteArray[11].call(this.ports.get(), callSiteArray[12].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object7, ConsulPorts.ConsulPortsBuilder.class)));
                    return object7;
                }
                return null;
            }

            public ConsulPorts.ConsulPortsBuilder getPorts() {
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                return (ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)this.ports.get(), ConsulPorts.ConsulPortsBuilder.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergePorts_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "key";
                stringArray[1] = "withDnsPort";
                stringArray[2] = "value";
                stringArray[3] = "withHttpPort";
                stringArray[4] = "value";
                stringArray[5] = "withSerfLanPort";
                stringArray[6] = "value";
                stringArray[7] = "withSerfWanPort";
                stringArray[8] = "value";
                stringArray[9] = "withServerPort";
                stringArray[10] = "value";
                stringArray[11] = "withGRpcPort";
                stringArray[12] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _mergePorts_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_mergePorts_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _mergePorts_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[4].call(extraPorts, (Object)new _mergePorts_closure1(this, this, ports2));
        return (ConsulPorts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)((ConsulPorts.ConsulPortsBuilder)ports2.get())), ConsulPorts.class);
    }

    private void makeDI() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        Object object = callSiteArray[6].callConstructor(HttpBinaryRepository.class);
        this.binaryRepository = (HttpBinaryRepository)ScriptBytecodeAdapter.castToType((Object)object, HttpBinaryRepository.class);
        Object object2 = callSiteArray[7].callConstructor(AntUnzip.class);
        this.unzip = (AntUnzip)ScriptBytecodeAdapter.castToType((Object)object2, AntUnzip.class);
    }

    public ConsulProcess start() {
        boolean bl;
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        callSiteArray[8].call((Object)logger, (Object)"Starting new Consul process.");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[9].callCurrent((GroovyObject)this);
        } else {
            this.checkInitialState();
        }
        this.started = bl = true;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callCurrent((GroovyObject)this))) {
                callSiteArray[11].callCurrent((GroovyObject)this);
            }
        } else if (!this.isBinaryDownloaded()) {
            this.downloadAndUnpackBinary();
        }
        callSiteArray[12].callCurrent((GroovyObject)this, (Object)this.consulPorts);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)this.customConfig))) {
                callSiteArray[14].callCurrent((GroovyObject)this);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call((Object)this.customConfig))) {
            this.createExtraConfigFile();
        }
        String downloadDirAsString = ShortTypeHandling.castToString((Object)callSiteArray[16].call(callSiteArray[17].call((Object)this.downloadDir)));
        String pathToConsul = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{downloadDirAsString}, new String[]{"", "/consul"}));
        if (ScriptBytecodeAdapter.compareEqual((Object)"windows", (Object)callSiteArray[18].call(OsResolver.class))) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{downloadDirAsString}, new String[]{"", "/consul.exe"});
            pathToConsul = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        String[] command = new String[]{pathToConsul, "agent", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataDir}, new String[]{"-data-dir=", ""})), "-dev", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.configDir}, new String[]{"-config-dir=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.advertise}, new String[]{"-advertise=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.client}, new String[]{"-client=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[19].callGetProperty((Object)this.logLevel)}, new String[]{"-log-level=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[20].callGroovyObjectGetProperty((Object)this.consulPorts)}, new String[]{"-http-port=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[21].callGroovyObjectGetProperty((Object)this.consulPorts)}, new String[]{"-grpc-port=", ""}))};
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.bind, null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call((Object)command, (Object)new GStringImpl(new Object[]{this.bind}, new String[]{"-bind=", ""})), String[].class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.startJoin, null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call((Object)command, (Object)new GStringImpl(new Object[]{this.startJoin}, new String[]{"-join=", ""})), String[].class);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[24].call((Object)this.customConfig, (Object)"node_id"), null)) {
                command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[26].call((Object)"-node-id=", callSiteArray[27].callStatic(ConsulStarter.class))})), String[].class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[28].call((Object)this.customConfig, (Object)"node_id"), null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[30].call((Object)"-node-id=", (Object)ConsulStarter.randomNodeId())})), String[].class);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[31].call((Object)this.customConfig, (Object)"node_name"), null)) {
                command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[33].call((Object)"-node=", callSiteArray[34].callStatic(ConsulStarter.class))})), String[].class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[35].call((Object)this.customConfig, (Object)"node_name"), null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[37].call((Object)"-node=", (Object)ConsulStarter.randomNodeName())})), String[].class);
        }
        Process innerProcess = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].callConstructor(ProcessBuilder.class), callSiteArray[44].call((Object)this.downloadDir)), (Object)command)), callSiteArray[45].callGetProperty(ProcessBuilder.Redirect.class))), Process.class);
        callSiteArray[46].call((Object)this.logHandler, callSiteArray[47].call((Object)innerProcess));
        SimpleConsulClient consulClient = (SimpleConsulClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call(ConsulClientFactory.class, (Object)this.advertise, callSiteArray[49].callGroovyObjectGetProperty((Object)this.consulPorts), callSiteArray[50].call(Optional.class, (Object)this.token)), SimpleConsulClient.class);
        ConsulWaiter consulWaiter = (ConsulWaiter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(ConsulWaiter.class, (Object)this.advertise, callSiteArray[52].callGroovyObjectGetProperty((Object)this.consulPorts), (Object)consulClient, callSiteArray[53].call(Optional.class, (Object)this.waitTimeout)), ConsulWaiter.class);
        ConsulProcess process = (ConsulProcess)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callConstructor(ConsulProcess.class, ArrayUtil.createArray((Object)this.dataDir, (Object)this.consulPorts, (Object)this.advertise, (Object)innerProcess, (Object)consulClient, (Object)consulWaiter, (Object)this.logHandler)), ConsulProcess.class);
        callSiteArray[55].call((Object)logger, (Object)"Starting Consul process on port {}", callSiteArray[56].callGroovyObjectGetProperty((Object)this.consulPorts));
        callSiteArray[57].call((Object)consulWaiter);
        callSiteArray[58].call((Object)logger, (Object)"Consul process started");
        return process;
    }

    private void checkInitialState() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (this.started) {
            throw (Throwable)callSiteArray[59].callConstructor(EmbeddedConsulException.class, (Object)"This Consul Starter instance already started Consul process. Create new ConsulStarter instance");
        }
        try {
            String string = this.bind;
            public class _checkInitialState_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _checkInitialState_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _checkInitialState_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _checkInitialState_closure2.$getCallSiteArray();
                    throw (Throwable)callSiteArray[0].callConstructor(EmbeddedConsulException.class, (Object)new GStringImpl(new Object[]{callSiteArray[1].callGroovyObjectGetProperty(callSiteArray[2].callGroovyObjectGetProperty((Object)this))}, new String[]{"Port ", " is not available, cannot start Consul process."}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkInitialState_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "httpPort";
                    stringArray[2] = "consulPorts";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _checkInitialState_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_checkInitialState_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _checkInitialState_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[60].call(IOGroovyMethods.class, callSiteArray[61].callConstructor(Socket.class, (Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "localhost"), callSiteArray[62].callGroovyObjectGetProperty((Object)this.consulPorts)), (Object)new _checkInitialState_closure2(this, this));
        }
        catch (IOException ex) {
        }
    }

    private void downloadAndUnpackBinary() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callConstructor(File.class, callSiteArray[64].call(callSiteArray[65].call((Object)this.downloadDir)), (Object)"consul.zip"), File.class);
        callSiteArray[66].call((Object)logger, (Object)"Downloading archives into: {}", callSiteArray[67].call((Object)file));
        File archive = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call((Object)this.binaryRepository, (Object)this.consulVersion, (Object)file), File.class);
        callSiteArray[69].call((Object)logger, (Object)"Unzipping binaries into: {}", callSiteArray[70].call((Object)this.downloadDir));
        callSiteArray[71].call((Object)this.unzip, (Object)archive, callSiteArray[72].call((Object)this.downloadDir));
    }

    private void createBasicConfigFile(ConsulPorts consulPorts) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File portsConfigFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callConstructor(File.class, callSiteArray[74].call((Object)this.configDir), (Object)"basic_config.json"), File.class);
        callSiteArray[75].call((Object)logger, (Object)"Creating ports configuration file: {}", callSiteArray[76].call((Object)portsConfigFile));
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[77].callGroovyObjectGetProperty((Object)consulPorts), callSiteArray[78].callGroovyObjectGetProperty((Object)consulPorts), callSiteArray[79].callGroovyObjectGetProperty((Object)consulPorts), callSiteArray[80].callGroovyObjectGetProperty((Object)consulPorts)}, new String[]{"\n            {\n                \"ports\": {\n                    \"dns\": ", ",\n                    \"serf_lan\": ", ",\n                    \"serf_wan\": ", ",\n                    \"server\": ", "\n                },\n                \"disable_update_check\": true,\n                \"performance\": {\n                    \"raft_multiplier\": 1\n                }\n            }\n        "});
        ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)portsConfigFile, (String)"text");
    }

    private void createExtraConfigFile() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File customConfigFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callConstructor(File.class, callSiteArray[82].call((Object)this.configDir), (Object)"extra_config.json"), File.class);
        callSiteArray[83].call((Object)logger, (Object)"Creating custom configuration file: {}", callSiteArray[84].call((Object)customConfigFile));
        Object object = callSiteArray[85].call((Object)this.customConfig);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)customConfigFile, (String)"text");
    }

    private boolean isBinaryDownloaded() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[86].call(callSiteArray[87].callCurrent((GroovyObject)this)));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].call((Object)this.getConsulBinary()));
    }

    public File getConsulBinary() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        String consulBinaryName = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[89].call(callSiteArray[90].call(OsResolver.class), (Object)"windows")) ? "consul.exe" : "consul";
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(File.class, callSiteArray[92].call((Object)this.downloadDir), (Object)consulBinaryName), File.class);
    }

    private static String randomNodeId() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].callStatic(ConsulStarter.class, (Object)8), (Object)"-"), callSiteArray[102].callStatic(ConsulStarter.class, (Object)4)), (Object)"-"), callSiteArray[103].callStatic(ConsulStarter.class, (Object)4)), (Object)"-"), callSiteArray[104].callStatic(ConsulStarter.class, (Object)4)), (Object)"-"), callSiteArray[105].callStatic(ConsulStarter.class, (Object)12)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].call(callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call((Object)ConsulStarter.randomHex(8), (Object)"-"), (Object)ConsulStarter.randomHex(4)), (Object)"-"), (Object)ConsulStarter.randomHex(4)), (Object)"-"), (Object)ConsulStarter.randomHex(4)), (Object)"-"), (Object)ConsulStarter.randomHex(12)));
    }

    private static String randomNodeName() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[114].call((Object)"node-", callSiteArray[115].callStatic(ConsulStarter.class, (Object)10)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[116].call((Object)"node-", (Object)ConsulStarter.randomHex(10)));
    }

    private static String randomHex(int len) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callConstructor(StringBuilder.class), StringBuilder.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i < len) {
                callSiteArray[118].call((Object)sb, callSiteArray[119].call(Long.class, callSiteArray[120].call((Object)random, (Object)16)));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[121].call((Object)n));
            }
        } else {
            int i = 0;
            while (i < len) {
                callSiteArray[122].call((Object)sb, callSiteArray[123].call(Long.class, callSiteArray[124].call((Object)random, (Object)16)));
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[125].call((Object)sb));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConsulStarter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ConsulStarter.$getCallSiteArray()[126].call(LoggerFactory.class, ConsulStarter.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = ConsulStarter.$getCallSiteArray()[127].callConstructor(Random.class);
        random = (Random)ScriptBytecodeAdapter.castToType((Object)object2, Random.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "mergePorts";
        stringArray[1] = "makeDI";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "get";
        stringArray[4] = "collect";
        stringArray[5] = "build";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "info";
        stringArray[9] = "checkInitialState";
        stringArray[10] = "isBinaryDownloaded";
        stringArray[11] = "downloadAndUnpackBinary";
        stringArray[12] = "createBasicConfigFile";
        stringArray[13] = "isEmpty";
        stringArray[14] = "createExtraConfigFile";
        stringArray[15] = "isEmpty";
        stringArray[16] = "toString";
        stringArray[17] = "toAbsolutePath";
        stringArray[18] = "resolve";
        stringArray[19] = "value";
        stringArray[20] = "httpPort";
        stringArray[21] = "grpcPort";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "get";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "randomNodeId";
        stringArray[28] = "get";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "get";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "randomNodeName";
        stringArray[35] = "get";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "start";
        stringArray[39] = "redirectOutput";
        stringArray[40] = "inheritIO";
        stringArray[41] = "command";
        stringArray[42] = "directory";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "toFile";
        stringArray[45] = "PIPE";
        stringArray[46] = "handleStream";
        stringArray[47] = "getInputStream";
        stringArray[48] = "newClient";
        stringArray[49] = "httpPort";
        stringArray[50] = "ofNullable";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "httpPort";
        stringArray[53] = "ofNullable";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "info";
        stringArray[56] = "httpPort";
        stringArray[57] = "awaitUntilConsulStarted";
        stringArray[58] = "info";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "withCloseable";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "httpPort";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "toString";
        stringArray[65] = "toAbsolutePath";
        stringArray[66] = "info";
        stringArray[67] = "toString";
        stringArray[68] = "getConsulBinaryArchive";
        stringArray[69] = "info";
        stringArray[70] = "toString";
        stringArray[71] = "unzip";
        stringArray[72] = "toFile";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "toFile";
        stringArray[75] = "info";
        stringArray[76] = "toString";
        stringArray[77] = "dnsPort";
        stringArray[78] = "serfLanPort";
        stringArray[79] = "serfWanPort";
        stringArray[80] = "serverPort";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "toFile";
        stringArray[83] = "info";
        stringArray[84] = "toString";
        stringArray[85] = "asString";
        stringArray[86] = "exists";
        stringArray[87] = "getConsulBinary";
        stringArray[88] = "exists";
        stringArray[89] = "equals";
        stringArray[90] = "resolve";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "toString";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = "plus";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "plus";
        stringArray[99] = "plus";
        stringArray[100] = "plus";
        stringArray[101] = "randomHex";
        stringArray[102] = "randomHex";
        stringArray[103] = "randomHex";
        stringArray[104] = "randomHex";
        stringArray[105] = "randomHex";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "plus";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "randomHex";
        stringArray[116] = "plus";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "append";
        stringArray[119] = "toHexString";
        stringArray[120] = "nextInt";
        stringArray[121] = "next";
        stringArray[122] = "append";
        stringArray[123] = "toHexString";
        stringArray[124] = "nextInt";
        stringArray[125] = "toString";
        stringArray[126] = "getLogger";
        stringArray[127] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[128];
        ConsulStarter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConsulStarter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConsulStarter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

