/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.request;

import com.qcloud.cos.common_utils.CommonParamCheckUtils;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.meta.InsertOnly;
import com.qcloud.cos.request.AbstractBaseRequest;

public class UploadFileRequest
extends AbstractBaseRequest {
    private static final int DEFAULT_TASK_NUM = 16;
    private String localPath;
    private String bizAttr;
    private byte[] contentBufer = null;
    private boolean uploadFromBuffer = false;
    private InsertOnly insertOnly = InsertOnly.NO_OVER_WRITE;
    protected boolean enableShaDigest = false;
    protected int taskNum = 16;

    public UploadFileRequest(String bucketName, String cosPath, String localPath, String bizAttr) {
        super(bucketName, cosPath);
        this.localPath = localPath;
        this.bizAttr = bizAttr;
        this.contentBufer = null;
        this.uploadFromBuffer = false;
    }

    public UploadFileRequest(String bucketName, String cosPath, String localPath) {
        this(bucketName, cosPath, localPath, "");
    }

    public UploadFileRequest(String bucketName, String cosPath, byte[] contentBuffer) {
        super(bucketName, cosPath);
        this.contentBufer = contentBuffer;
        this.uploadFromBuffer = true;
        this.bizAttr = "";
    }

    public String getBizAttr() {
        return this.bizAttr;
    }

    public void setBizAttr(String bizAttr) {
        this.bizAttr = bizAttr;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
        this.uploadFromBuffer = false;
    }

    public InsertOnly getInsertOnly() {
        return this.insertOnly;
    }

    public void setInsertOnly(InsertOnly insertOnly) {
        this.insertOnly = insertOnly;
    }

    public byte[] getContentBufer() {
        return this.contentBufer;
    }

    public void setContentBufer(byte[] contentBufer) {
        this.contentBufer = contentBufer;
        this.uploadFromBuffer = true;
    }

    public boolean isUploadFromBuffer() {
        return this.uploadFromBuffer;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        CommonParamCheckUtils.AssertLegalCosFilePath(this.getCosPath());
        CommonParamCheckUtils.AssertNotNull("biz_attr", this.bizAttr);
        CommonParamCheckUtils.AssertNotNull("insertOnly", (Object)this.insertOnly);
        if (!this.uploadFromBuffer) {
            CommonParamCheckUtils.AssertLegalLocalFilePath(this.localPath);
        } else {
            CommonParamCheckUtils.AssertNotNull("contentBufer", this.contentBufer);
        }
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(int taskNum) {
        this.taskNum = taskNum;
    }

    public boolean isEnableShaDigest() {
        return this.enableShaDigest;
    }

    public void setEnableShaDigest(boolean enableShaDigest) {
        this.enableShaDigest = enableShaDigest;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", local_path:").append(this.getMemberStringValue(this.localPath));
        sb.append(", bizAttr:").append(this.getMemberStringValue(this.bizAttr));
        sb.append(", uploadFromBuffer:").append(this.uploadFromBuffer);
        sb.append(", insertonly:");
        if (this.insertOnly == null) {
            sb.append("null");
        } else {
            sb.append(this.insertOnly.ordinal());
        }
        return sb.toString();
    }
}

