/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.common_utils;

import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.exception.ParamException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonParamCheckUtils {
    public static void AssertNotNull(String objName, Object obj) throws ParamException {
        if (obj == null) {
            throw new ParamException(objName + " is null, please check!");
        }
    }

    public static void AssertUploadEntireFileInRange(String localFilePath) throws ParamException {
        long fileSize = 0L;
        try {
            fileSize = CommonFileUtils.getFileLength(localFilePath);
        }
        catch (Exception e) {
            throw new ParamException(localFilePath + " is not effective file!");
        }
        long maxFileSize = 0xA00000L;
        if (fileSize > maxFileSize) {
            throw new ParamException(localFilePath + " is too large, please use uploadSliceFile interface!");
        }
    }

    public static void AssertSliceInRange(int sliceSize) throws ParamException {
        int maxSliceSize = 0xA00000;
        int minSliceSize = 65536;
        if (sliceSize > maxSliceSize || sliceSize < minSliceSize) {
            throw new ParamException("sliceSize legal value is [64KB, 100MB]");
        }
    }

    private static void AssertNotContainIllegalLetter(String cosPath) throws ParamException {
        String[] illegalLetters;
        for (String illegalLetter : illegalLetters = new String[]{"?", "*", ":", "|", "\\", "<", ">", "\""}) {
            if (!cosPath.contains(illegalLetter)) continue;
            throw new ParamException("cosFilePath contail illeagl letter " + illegalLetter);
        }
        String pattern = "/(\\s*)/";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(cosPath);
        if (m.find()) {
            throw new ParamException("cosFilePath contail illeagl letter / /");
        }
    }

    public static void AssertLegalCosFolderPath(String cosFolderPath) throws ParamException {
        if (cosFolderPath == null || !cosFolderPath.startsWith("/") || !cosFolderPath.endsWith("/")) {
            throw new ParamException(cosFolderPath + " is not cos folder path! Tips: make sure ends with /");
        }
        CommonParamCheckUtils.AssertNotContainIllegalLetter(cosFolderPath);
    }

    public static void AssertLegalCosFilePath(String cosFilePath) throws ParamException {
        if (cosFilePath == null || !cosFilePath.startsWith("/") || cosFilePath.endsWith("/")) {
            throw new ParamException(cosFilePath + " is not cos file path! Tips: make sure not ends with /");
        }
    }

    public static void AssertNotRootCosPath(String cosCosFolderPath) throws ParamException {
        if (cosCosFolderPath == null || cosCosFolderPath.equals("/")) {
            throw new ParamException("bucket operation is only allowed by web console! please visit http://console.qcloud.com/cos!");
        }
    }

    public static void AssertLegalLocalFilePath(String localFilePath) throws ParamException {
        if (localFilePath == null || !CommonFileUtils.isLegalFile(localFilePath)) {
            throw new ParamException(localFilePath + " is not file or not exist or can't be read!");
        }
    }

    public static void AssertLegalXCosMeta(Map<String, String> xCosMetaMap) throws ParamException {
        for (String x_cos_meta_key : xCosMetaMap.keySet()) {
            CommonParamCheckUtils.AssertNotNull("x_cos_meta_key", x_cos_meta_key);
            if (!x_cos_meta_key.startsWith("x-cos-meta-")) {
                throw new ParamException("x-cos-meta name must starts with x-cos-meta-");
            }
            String x_cos_meta_value = xCosMetaMap.get(x_cos_meta_key);
            CommonParamCheckUtils.AssertNotNull("x_cos_meta_value", x_cos_meta_value);
            if (!x_cos_meta_value.isEmpty()) continue;
            throw new ParamException("x-cos-meta value can't be empty!");
        }
    }

    public static void AssertLegalUpdateFlag(int updateFlag) throws ParamException {
        if (updateFlag == 0) {
            throw new ParamException("please update at least one attribute!");
        }
    }

    public static void AssertLegalSliceSize(int sliceSize) throws ParamException {
        if (sliceSize != 524288 && sliceSize != 0x100000 && sliceSize != 0x200000 && sliceSize != 0x300000) {
            throw new ParamException("valid slice is 512KB, 1MB, 2MB, 3MB");
        }
    }
}

