/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.ObjectRestoreResult;
import com.qcloud.cos.utils.DateUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectRestoreHeaderHandler<T extends ObjectRestoreResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern ongoingPattern = Pattern.compile("ongoing-request=\"(.*?)\"");
    private static final Logger log = LoggerFactory.getLogger(ObjectRestoreHeaderHandler.class);

    @Override
    public void handle(T result, CosHttpResponse response) {
        String restoreHeader = response.getHeaders().get("x-cos-restore");
        if (restoreHeader != null) {
            result.setRestoreExpirationTime(this.parseDate(restoreHeader));
            Boolean onGoingRestore = this.parseBoolean(restoreHeader);
            if (onGoingRestore != null) {
                result.setOngoingRestore(onGoingRestore);
            }
        }
    }

    private Date parseDate(String restoreHeader) {
        Matcher matcher = datePattern.matcher(restoreHeader);
        if (matcher.find()) {
            String date = matcher.group(1);
            try {
                return DateUtils.parseRFC822Date(date);
            }
            catch (Exception exception) {
                log.warn("Error parsing expiry-date from x-amz-restore header.", (Throwable)exception);
            }
        }
        return null;
    }

    private Boolean parseBoolean(String restoreHeader) {
        Matcher matcher = ongoingPattern.matcher(restoreHeader);
        if (matcher.find()) {
            String ongoingRestore = matcher.group(1);
            return Boolean.parseBoolean(ongoingRestore);
        }
        return null;
    }
}

