/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.resumableio;

import com.qiniu.api.resumableio.ChunkUploadCallRet;
import com.qiniu.api.resumableio.SliceUpload;
import com.qiniu.api.resumableio.Util;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class UploadBlock {
    public static int CHUNK_SIZE = 262144;
    public static int FIRST_CHUNK = 262144;
    public static int triedTimes = 3;
    protected HttpClient httpClient;
    protected String orginHost;
    protected int blockIdx;
    protected long offset;
    protected int length;
    protected SliceUpload sliceUpload;

    public UploadBlock(SliceUpload sliceUpload, HttpClient httpClient, String host, int blockIdx, long offset, int len) {
        this.sliceUpload = sliceUpload;
        this.httpClient = httpClient;
        this.orginHost = host;
        this.blockIdx = blockIdx;
        this.offset = offset;
        this.length = len;
    }

    public ChunkUploadCallRet execute() throws Exception {
        int flen = Math.min(this.length, FIRST_CHUNK);
        ChunkUploadCallRet ret = this.uploadMkblk(flen, 0);
        this.checkChunkCallRet(ret);
        if (this.length > FIRST_CHUNK) {
            int count = (this.length - FIRST_CHUNK + CHUNK_SIZE - 1) / CHUNK_SIZE;
            for (int i = 0; i < count; ++i) {
                int start = CHUNK_SIZE * i + FIRST_CHUNK;
                int len = Math.min(this.length - start, CHUNK_SIZE);
                ret = this.uploadChunk(ret, start, len, 0);
                this.checkChunkCallRet(ret);
            }
        }
        this.clean();
        return ret;
    }

    private void checkChunkCallRet(ChunkUploadCallRet ret) throws Exception {
        if (ret == null || !ret.ok()) {
            this.clean();
            if (ret.exception != null) {
                throw ret.exception;
            }
            throw new Exception();
        }
    }

    private ChunkUploadCallRet uploadMkblk(int len, int time) {
        String url = this.getMkblkUrl();
        return this.upload(url, 0, len, time);
    }

    private ChunkUploadCallRet uploadChunk(ChunkUploadCallRet ret, int start, int len, int time) {
        String url = this.getBlkUrl(ret);
        return this.upload(url, start, len, time);
    }

    private ChunkUploadCallRet upload(String url, int start, int len, int time) {
        try {
            HttpPost post = Util.buildUpPost(url, this.sliceUpload.token);
            post.setEntity(this.buildHttpEntity(start, len));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            ChunkUploadCallRet ret = new ChunkUploadCallRet(Util.handleResult(response));
            return this.checkAndRetryUpload(url, start, len, time, ret);
        }
        catch (Exception e) {
            return new ChunkUploadCallRet(0, e);
        }
    }

    private ChunkUploadCallRet checkAndRetryUpload(String url, int start, int len, int time, ChunkUploadCallRet ret) {
        if (!ret.ok()) {
            if ((ret.statusCode == 406 || ret.statusCode == 701 || ret.statusCode / 100 == 5) && time < triedTimes) {
                return this.upload(url, start, len, time + 1);
            }
            return ret;
        }
        long crc32 = this.buildCrc32(start, len);
        if (ret.getCrc32() != crc32) {
            if (time < triedTimes) {
                return this.upload(url, start, len, time + 1);
            }
            return new ChunkUploadCallRet(406, "inner block's crc32 do not match.");
        }
        this.sliceUpload.addSuccessLength(len);
        return ret;
    }

    private String getMkblkUrl() {
        String url = this.orginHost + "/mkblk/" + this.length;
        return url;
    }

    private String getBlkUrl(ChunkUploadCallRet ret) {
        String url = ret.getHost() + "/bput/" + ret.getCtx() + "/" + ret.getOffset();
        return url;
    }

    protected abstract HttpEntity buildHttpEntity(int var1, int var2);

    protected abstract long buildCrc32(int var1, int var2);

    protected abstract void clean();
}

