/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.AsyncCallback;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UpCompletionHandler;
import com.qiniu.util.Crc32;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.IOException;

public final class FormUploader {
    private final String token;
    private final String key;
    private final File file;
    private final byte[] data;
    private final String mime;
    private final boolean checkCrc;
    private final ConfigHelper configHelper;
    private StringMap params;
    private Client client;
    private String fileName;

    public FormUploader(Client client, String upToken, String key, byte[] data, StringMap params, String mime, boolean checkCrc, Configuration configuration) {
        this(client, upToken, key, data, null, params, mime, checkCrc, configuration);
    }

    public FormUploader(Client client, String upToken, String key, File file, StringMap params, String mime, boolean checkCrc, Configuration configuration) {
        this(client, upToken, key, null, file, params, mime, checkCrc, configuration);
    }

    private FormUploader(Client client, String upToken, String key, byte[] data, File file, StringMap params, String mime, boolean checkCrc, Configuration configuration) {
        this.client = client;
        this.token = upToken;
        this.key = key;
        this.file = file;
        this.data = data;
        this.params = params;
        this.mime = mime;
        this.checkCrc = checkCrc;
        this.configHelper = new ConfigHelper(configuration);
    }

    public Response upload() throws QiniuException {
        this.buildParams();
        String host = this.configHelper.upHost(this.token);
        try {
            if (this.data != null) {
                return this.client.multipartPost(this.configHelper.upHost(this.token), this.params, "file", this.fileName, this.data, this.mime, new StringMap());
            }
            return this.client.multipartPost(this.configHelper.upHost(this.token), this.params, "file", this.fileName, this.file, this.mime, new StringMap());
        }
        catch (QiniuException e) {
            if (e.response == null || e.response.needSwitchServer()) {
                this.changeHost(this.token, host);
            }
            throw e;
        }
    }

    public void asyncUpload(final UpCompletionHandler handler) throws IOException {
        this.buildParams();
        final String host = this.configHelper.upHost(this.token);
        if (this.data != null) {
            this.client.asyncMultipartPost(host, this.params, "file", this.fileName, this.data, this.mime, new StringMap(), new AsyncCallback(){

                @Override
                public void complete(Response res) {
                    if (res != null && res.needSwitchServer()) {
                        FormUploader.this.changeHost(FormUploader.this.token, host);
                    }
                    handler.complete(FormUploader.this.key, res);
                }
            });
            return;
        }
        this.client.asyncMultipartPost(this.configHelper.upHost(this.token), this.params, "file", this.fileName, this.file, this.mime, new StringMap(), new AsyncCallback(){

            @Override
            public void complete(Response res) {
                if (res != null && res.needSwitchServer()) {
                    FormUploader.this.changeHost(FormUploader.this.token, host);
                }
                handler.complete(FormUploader.this.key, res);
            }
        });
    }

    private void changeHost(String upToken, String host) {
        try {
            this.configHelper.tryChangeUpHost(upToken, host);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildParams() throws QiniuException {
        this.params.put("token", this.token);
        if (this.key != null) {
            this.params.put("key", this.key);
        }
        if (this.file != null) {
            this.fileName = this.file.getName();
        }
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.fileName = "fileName";
        }
        long crc32 = 0L;
        if (this.file != null) {
            try {
                crc32 = Crc32.file(this.file);
            }
            catch (IOException e) {
                throw new QiniuException(e);
            }
        } else {
            crc32 = Crc32.bytes(this.data);
        }
        this.params.put("crc32", "" + crc32);
    }
}

