/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.DeliveryPriority;
import java.util.Date;
import java.util.Objects;

public class SimpleApnsPushNotification
implements ApnsPushNotification {
    private final String token;
    private final String payload;
    private final Date invalidationTime;
    private final DeliveryPriority priority;
    private final String topic;
    private final String collapseId;

    public SimpleApnsPushNotification(String token, String topic, String payload) {
        this(token, topic, payload, null, DeliveryPriority.IMMEDIATE, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime) {
        this(token, topic, payload, invalidationTime, DeliveryPriority.IMMEDIATE, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority) {
        this(token, topic, payload, invalidationTime, priority, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, String collapseId) {
        this.token = token;
        this.payload = payload;
        this.invalidationTime = invalidationTime;
        this.priority = priority;
        this.topic = topic;
        this.collapseId = collapseId;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public Date getExpiration() {
        return this.invalidationTime;
    }

    @Override
    public DeliveryPriority getPriority() {
        return this.priority;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getCollapseId() {
        return this.collapseId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invalidationTime == null ? 0 : this.invalidationTime.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        result = 31 * result + (this.collapseId == null ? 0 : this.collapseId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleApnsPushNotification)) {
            return false;
        }
        SimpleApnsPushNotification other = (SimpleApnsPushNotification)obj;
        if (this.invalidationTime == null ? other.invalidationTime != null : !this.invalidationTime.equals(other.invalidationTime)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.token == null ? other.token != null : !this.token.equals(other.token)) {
            return false;
        }
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        return !(Objects.equals(this.collapseId, null) ? !Objects.equals(other.collapseId, null) : !this.collapseId.equals(other.collapseId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleApnsPushNotification [token=");
        builder.append(this.token);
        builder.append(", payload=");
        builder.append(this.payload);
        builder.append(", invalidationTime=");
        builder.append(this.invalidationTime);
        builder.append(", priority=");
        builder.append((Object)this.priority);
        builder.append(", topic=");
        builder.append(this.topic);
        builder.append(", apns-collapse-id=");
        builder.append(this.collapseId);
        builder.append("]");
        return builder.toString();
    }
}

