/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Checksum
extends Enum<Checksum> {
    public static final /* enum */ Checksum SHA1 = new Checksum("sha1", new String[]{"SHA-1"}){

        @Override
        protected MessageDigest getDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance("SHA-1");
        }
    };
    public static final /* enum */ Checksum MD5 = new Checksum("md5", new String[]{"MD5"}){

        @Override
        protected MessageDigest getDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance("MD5");
        }
    };
    private static final Map<String, Checksum> CHECKSUM_BY_ALIAS;
    private static final char[] HEX_DIGITS;
    private static final int BUFFER_SIZE = 65535;
    private final String defaultExtension;
    private final List<String> aliases;
    private static final /* synthetic */ Checksum[] $VALUES;

    public static Checksum[] values() {
        return (Checksum[])$VALUES.clone();
    }

    public static Checksum valueOf(String name) {
        return Enum.valueOf(Checksum.class, name);
    }

    private Checksum(String defaultExtension, String ... aliases) {
        this.defaultExtension = defaultExtension;
        this.aliases = Arrays.asList(aliases);
    }

    public static Checksum fromAlias(String alias) {
        return CHECKSUM_BY_ALIAS.get(alias);
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public boolean verify(InputStream data, String checksum) {
        return checksum.equals(this.generate(data));
    }

    public String generate(InputStream data) {
        try {
            byte[] buffer = new byte[65535];
            int length = 0;
            MessageDigest digest = this.getDigest();
            while ((length = data.read(buffer)) > 0) {
                digest.update(buffer, 0, length);
            }
            return Checksum.asHex(digest.digest());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not generate checksum for stream.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not generate checksum for stream.", e);
        }
    }

    protected abstract MessageDigest getDigest() throws NoSuchAlgorithmException;

    private static String asHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(HEX_DIGITS[(b & 0xF0) >> 4]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    static {
        $VALUES = new Checksum[]{SHA1, MD5};
        CHECKSUM_BY_ALIAS = new HashMap<String, Checksum>();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (Checksum checksum : Checksum.values()) {
            for (String alias : checksum.aliases) {
                assert (!CHECKSUM_BY_ALIAS.containsKey(alias)) : "Duplicate checksum alias detected: " + alias;
                CHECKSUM_BY_ALIAS.put(alias, checksum);
            }
        }
    }
}

