/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import org.apache.maven.wrapper.WrapperConfiguration;

public class PathAssembler {
    public static final String MAVEN_USER_HOME_STRING = "MAVEN_USER_HOME";
    public static final String PROJECT_STRING = "PROJECT";
    private File mavenUserHome;

    public PathAssembler() {
    }

    public PathAssembler(File mavenUserHome) {
        this.mavenUserHome = mavenUserHome;
    }

    public LocalDistribution getDistribution(WrapperConfiguration configuration, URI distributionUrl) {
        String baseName = this.getDistName(distributionUrl);
        String distName = this.removeExtension(baseName);
        String rootDirName = this.rootDirName(distName, distributionUrl);
        File distDir = new File(this.getBaseDir(configuration.getDistributionBase()), configuration.getDistributionPath() + "/" + rootDirName);
        File distZip = new File(this.getBaseDir(configuration.getZipBase()), configuration.getZipPath() + "/" + rootDirName + "/" + baseName);
        return new LocalDistribution(distDir, distZip);
    }

    private String rootDirName(String distName, URI distributionUrl) {
        String urlHash = this.getMd5Hash(distributionUrl.toString());
        return String.format("%s/%s", distName, urlHash);
    }

    private String getMd5Hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = string.getBytes();
            messageDigest.update(bytes);
            return new BigInteger(1, messageDigest.digest()).toString(32);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not hash input string.", e);
        }
    }

    private String removeExtension(String name) {
        int p = name.lastIndexOf(".");
        if (p < 0) {
            return name;
        }
        return name.substring(0, p);
    }

    private String getDistName(URI distUrl) {
        String path = distUrl.getPath();
        int p = path.lastIndexOf("/");
        if (p < 0) {
            return path;
        }
        return path.substring(p + 1);
    }

    private File getBaseDir(String base) {
        if (base.equals(MAVEN_USER_HOME_STRING)) {
            return this.mavenUserHome;
        }
        if (base.equals(PROJECT_STRING)) {
            return new File(System.getProperty("user.dir"));
        }
        throw new RuntimeException("Base: " + base + " is unknown");
    }

    public static class LocalDistribution {
        private final File distZip;
        private final File distDir;

        public LocalDistribution(File distDir, File distZip) {
            this.distDir = distDir;
            this.distZip = distZip;
        }

        public File getDistributionDir() {
            return this.distDir;
        }

        public File getZipFile() {
            return this.distZip;
        }
    }
}

