/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.wrapper.BootstrapMainStarter;
import org.apache.maven.wrapper.Checksum;
import org.apache.maven.wrapper.Installer;
import org.apache.maven.wrapper.WrapperConfiguration;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    public static final String VERIFY_DOWNLOAD_PROPERTY = "verifyDownload";
    public static final String CHECKSUM_ALGORITHM_PROPERTY = "checksumAlgorithm";
    public static final String CHECKSUM_URL_PROPERTY = "checksumUrl";
    private final Properties properties;
    private final File propertiesFile;
    private final WrapperConfiguration config = new WrapperConfiguration();

    public static WrapperExecutor forProjectDirectory(File projectDir) {
        return new WrapperExecutor(new File(projectDir, "maven/wrapper/maven-wrapper.properties"), new Properties());
    }

    public static WrapperExecutor forWrapperPropertiesFile(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new RuntimeException(String.format("Wrapper properties file '%s' does not exist.", propertiesFile));
        }
        return new WrapperExecutor(propertiesFile, new Properties());
    }

    WrapperExecutor(File propertiesFile, Properties properties) {
        this.properties = properties;
        this.propertiesFile = propertiesFile;
        if (propertiesFile.exists()) {
            try {
                WrapperExecutor.loadProperties(propertiesFile, properties);
                this.config.setDistributionBase(this.getProperty(DISTRIBUTION_BASE_PROPERTY, this.config.getDistributionBase()));
                this.config.setDistributionPath(this.getProperty(DISTRIBUTION_PATH_PROPERTY, this.config.getDistributionPath()));
                this.config.setZipBase(this.getProperty(ZIP_STORE_BASE_PROPERTY, this.config.getZipBase()));
                this.config.setZipPath(this.getProperty(ZIP_STORE_PATH_PROPERTY, this.config.getZipPath()));
                this.config.setDistributionUris(this.prepareDistributionUris());
                this.config.setVerifyDownload(Boolean.valueOf(this.getProperty(VERIFY_DOWNLOAD_PROPERTY, "false")));
                if (this.config.isVerifyDownload()) {
                    this.config.setChecksumAlgorithm(Checksum.valueOf(this.getProperty(CHECKSUM_ALGORITHM_PROPERTY)));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        }
    }

    private List<URI> prepareDistributionUris() throws URISyntaxException {
        return this.readRequiredUriList(DISTRIBUTION_URL_PROPERTY);
    }

    private List<URI> readRequiredUriList(String key) throws URISyntaxException {
        ArrayList<URI> uriList = new ArrayList<URI>();
        if (this.properties.getProperty(key) != null) {
            for (String value : this.getProperty(key).split(",")) {
                if (value.trim().length() == 0) continue;
                URI uri = URI.create(value);
                if (uri.getScheme() == null) {
                    uri = new File(this.propertiesFile.getParentFile(), uri.getSchemeSpecificPart()).toURI();
                }
                uriList.add(uri);
            }
            return uriList;
        }
        this.reportMissingProperty(key);
        return null;
    }

    private static void loadProperties(File propertiesFile, Properties properties) throws IOException {
        FileInputStream inStream = new FileInputStream(propertiesFile);
        try {
            properties.load(inStream);
        }
        finally {
            ((InputStream)inStream).close();
        }
    }

    public List<URI> getDistributionUris() {
        return this.config.getDistributionUris();
    }

    public WrapperConfiguration getConfiguration() {
        return this.config;
    }

    public void execute(String[] args, Installer install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        File mavenHome = install.createDist(this.config);
        bootstrapMainStarter.start(args, mavenHome);
    }

    private String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    private String getProperty(String propertyName, String defaultValue) {
        String value = this.properties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return this.reportMissingProperty(propertyName);
    }

    private String reportMissingProperty(String propertyName) {
        throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
    }
}

