package com.ruijc;

//                            _ooOoo_
//                           o8888888o
//                           88" . "88
//                           (| -_- |)
//                            O\ = /O
//                        ____/`---'\____
//                      .   ' \\| |// `.
//                       / \\||| : |||// \
//                     / _||||| -:- |||||- \
//                       | | \\\ - /// | |
//                     | \_| ''\---/'' | |
//                      \ .-\__ `-` ___/-. /
//                   ___`. .' /--.--\ `. . __
//                ."" '< `.___\_<|>_/___.' >'"".
//               | | : `- \`.;`\ _ /`;.`/ - ` : | |
//                 \ \ `-. \_ __\ /__ _/ .-` / /
//         ======`-.____`-.___\_____/___.-`____.-'======
//                            `=---='
//
//         .............................................
//                  佛祖镇楼                  BUG辟易
//          佛曰:
//                  写字楼里写字间，写字间里程序员；
//                  程序人员写程序，又拿程序换酒钱。
//                  酒醒只在网上坐，酒醉还来网下眠；
//                  酒醉酒醒日复日，网上网下年复年。
//                  但愿老死电脑间，不愿鞠躬老板前；
//                  奔驰宝马贵者趣，公交自行程序员。
//                  别人笑我忒疯癫，我笑自己命太贱；
//                  不见满街漂亮妹，哪个归得程序员？

/**
 * 操作统一返回
 *
 * @author Storezhang
 * Created 2016-12-29 02:39
 * Email storezhang@gmail.com
 * QQ 160290688
 */
public class Response<T> extends BaseObject {

    public static final int OK = 200;//操作正确
    public static final int FAILD = 400;//操作有错误
    public static final int ERROR = 500;//异常
    public static final int DISABLED = 700;//该功能已经被禁用

    private int code;//操作的状态码
    private String msg;//消息
    private T data;//数据

    public static boolean isSuccess(Response rsp) {
        return null != rsp && rsp.isSuccess();
    }

    public Response() {
        code = OK;
    }

    public boolean isSuccess() {
        return OK == code;
    }

    public void setSuccess(boolean success) {
        if (success) {
            code = OK;
        } else {
            code = FAILD;
        }
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
