/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    public static final long SEC_MILLIS = 1000L;
    public static final long MIN_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    public static final long WEEK_MILLIS = 604800000L;
    public static final long MONTH_MILLIS = 2592000000L;
    public static final long YEAR_MILLIS = 31536000000L;
    public static final int SEC = 1;
    public static final int MIN_SEC = 60;
    public static final int HOUR_SEC = 3600;
    public static final int DAY_SEC = 86400;
    public static final int WEEK_SE = 604800;
    public static final int MONTH_SEC = 2592000;
    public static final int YEAR_SEC = 31536000;

    public static int days(Date date) {
        long l = date.getTime();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        int n = (int)(l3 / 1000L / 3600L / 24L);
        return n;
    }

    public static String time(Integer n) {
        return TimeUtils.time((long)n);
    }

    public static String time(Long l) {
        long l2 = l / 3600000L;
        l = l % 3600000L;
        long l3 = l / 60000L;
        l = l % 60000L;
        long l4 = l / 1000L;
        Long.valueOf(l % 1000L);
        return String.format("%02d:%02d:%02d", l2, l3, l4);
    }

    public static Date todayStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date todayEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 24);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date yesterdayStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date yesterdayEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date thisWeekStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date thisWeekEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeUtils.thisWeekStart());
        calendar.add(7, 7);
        return calendar.getTime();
    }

    public static Date thisMonthStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date thisMonthEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 24);
        return calendar.getTime();
    }

    public static Date thisYearEnd() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return simpleDateFormat.parse(n + "-12-31 23:59:59");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date thisYearStart() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return simpleDateFormat.parse(n + "-01-01 00:00:00");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date lastYearEnd() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1) - 1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return simpleDateFormat.parse(n + "-12-31 23:59:59");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date lastYearStart() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1) - 1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return simpleDateFormat.parse(n + "-01-01 00:00:00");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static boolean setSystemTime(Date date) {
        String string = System.getProperty("os.name");
        try {
            if (string.matches("^(?i)Windows.*$")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss");
                string = String.format("cmd /c time %s", simpleDateFormat2.format(date));
                Runtime.getRuntime().exec(string);
                string = String.format("cmd /c date %s", simpleDateFormat.format(date));
                Runtime.getRuntime().exec(string);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("HH:mm:ss");
                string = String.format("date -s %s", simpleDateFormat.format(date));
                Runtime.getRuntime().exec(string);
                string = String.format("date -s %s", simpleDateFormat3.format(date));
                Runtime.getRuntime().exec(string);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println("---->" + TimeUtils.time(753000));
    }
}

