/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal;

import com.seeyon.cap4.bizportal.utils.EnumCode;

public interface BizPortalConstants {
    public static final Integer DEFAULT_SORT = 10;
    public static final String CONFIG_JSON_NAME = "config.json";

    public static enum GoodsClassKey {
        PORTAL_SPACE("tpBizSpace"),
        PORTAL_SPACE_Section("tpBizSection"),
        PORTAL_SPACE_THEME("tpBizTheme");

        String key;

        private GoodsClassKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum Order {
        NONE,
        DESC,
        ASC;

    }

    public static enum LayoutType implements EnumCode
    {
        SYSTEM(0, "\u7cfb\u7edf\u9884\u7f6e"),
        Collected(1, "\u4e2a\u4eba\u6536\u85cf");

        int code;
        String name;

        private LayoutType(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum ConfigStatus implements EnumCode
    {
        RUNNING(0, "\u8fd0\u884c\u6001"),
        EDITING(1, "\u7f16\u8f91\u6001"),
        HISTORY(2, "\u5386\u53f2\u6001"),
        Initial(3, "\u521d\u59cb\u6001");

        int code;
        String name;

        private ConfigStatus(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum SourceType implements EnumCode
    {
        Local(0, "\u672c\u5730\u5bfc\u5165"),
        CLOUD_CENTER(1, "\u534f\u540c\u4e91\u5546\u57ce"),
        SYSTEM(2, "\u7cfb\u7edf\u9884\u7f6e");

        int code;
        String name;

        private SourceType(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum FrameType implements EnumCode
    {
        BIZ_PORTAL_INDEX(0, "\u4e1a\u52a1\u9996\u9875");

        int code;
        String name;

        private FrameType(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum State implements EnumCode
    {
        DISABLE(0, "\u505c\u7528"),
        ENABLE(1, "\u542f\u7528");

        int code;
        String name;

        private State(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Platform implements EnumCode
    {
        ALL(0, "\u5168\u90e8"){

            @Override
            public boolean contains(Platform platform) {
                return true;
            }
        }
        ,
        PC(1, "\u7535\u8111\u7aef"),
        MOBILE(2, "\u79fb\u52a8\u7aef");

        int code;
        String name;

        private Platform(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public boolean contains(Platform platform) {
            return this.equals(platform);
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum DataFormat implements EnumCode
    {
        INDICATOR(1, "\u6307\u6807"),
        LINK(2, "\u5feb\u6377\u5165\u53e3"),
        MENU(3, "\u83dc\u5355"),
        LIST(4, "\u5217\u8868"),
        STATISTIC(5, "\u7edf\u8ba1\u5217\u8868"),
        MemberInfo(6, "\u4e2a\u4eba\u4fe1\u606f"),
        BIZ_MAP(7, "\u4e1a\u52a1\u5bfc\u56fe");

        int code;
        String name;

        private DataFormat(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Version {
        V1;


        public static Version[] of(String versionStr) {
            String[] vv = versionStr.split(",");
            Version[] versions = new Version[vv.length];
            for (int i = 0; i < vv.length; ++i) {
                versions[i] = Version.valueOf(vv[i]);
            }
            return versions;
        }
    }
}

