/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.api;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.api.BizPortalApi;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.dao.CAPBusinessTemplateDAO;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public class BizPortalApiImpl
implements BizPortalApi {
    private BizPortalSpaceManager bizPortalSpaceManager;
    private CAPBusinessTemplateDAO capBusinessTemplateDAO;

    @Override
    public List<CAPPortalSpace> findAvailableCAPPortalSpace(ContextParam contextParam) throws BusinessException {
        return this.bizPortalSpaceManager.findAvailableCAPPortalSpace(contextParam);
    }

    @Override
    public CAPPortalSpaceConfig getBizPortalSpaceConfig(Long spaceId) throws BusinessException {
        return this.bizPortalSpaceManager.getBizPortalSpaceConfig(spaceId, BizPortalConstants.ConfigStatus.RUNNING);
    }

    @Override
    public void deleteBizPortalSpaceAll(Long bizId, User user) throws BusinessException {
        this.bizPortalSpaceManager.deleteBizPortalSpaceAll(bizId, user);
    }

    @Override
    public List<Long> findCAPPortalGoodSnapshotId(Long configId) throws BusinessException {
        return this.bizPortalSpaceManager.findCAPPortalGoodSnapshotId(configId);
    }

    @Override
    public boolean showOrHideOldPortal(Long bizId) throws BusinessException {
        List<CAPBusinessTemplate> list = this.capBusinessTemplateDAO.getCAPBusinessTemplatesByBizId(bizId);
        ArrayList indexes = Lists.newArrayListWithCapacity((int)list.size());
        for (CAPBusinessTemplate template : list) {
            if (!ObjectUtils.equals((Object)template.getTemplateType(), (Object)CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) continue;
            indexes.add(template);
        }
        return CollectionUtils.isNotEmpty((Collection)indexes);
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }

    public void setCapBusinessTemplateDAO(CAPBusinessTemplateDAO capBusinessTemplateDAO) {
        this.capBusinessTemplateDAO = capBusinessTemplateDAO;
    }
}

