/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.bean;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionElement;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BizPortalLayoutConfig
extends HashMap<String, Object>
implements Serializable {
    private static final String ROWS = "rows";
    private static final String COLS = "cols";
    private static final String COLUMN_GROUPS = "columnGroups";
    private static final String COLUMNS = "columns";

    public BizPortalLayoutConfig(String layout) {
        if (StringUtils.isNotEmpty((CharSequence)layout)) {
            this.putAll((Map)JSONUtil.parseJSONString((String)layout, Map.class));
        }
    }

    public List<BizPortalSectionConfigJson> listSectionConfig() {
        List<Map<String, Object>> rows = this.getRows();
        if (CollectionUtils.isEmpty(rows)) {
            return Collections.emptyList();
        }
        ArrayList sections = Lists.newArrayList();
        for (Map<String, Object> row : rows) {
            List cols = (List)row.get(COLS);
            if (!CollectionUtils.isNotEmpty((Collection)cols)) continue;
            for (Map col : cols) {
                List columnGroups = (List)col.get(COLUMN_GROUPS);
                if (!CollectionUtils.isNotEmpty((Collection)columnGroups)) continue;
                for (Map columnGroup : columnGroups) {
                    List columns = (List)columnGroup.get(COLUMNS);
                    if (!CollectionUtils.isNotEmpty((Collection)columns)) continue;
                    Iterator iterator = columns.iterator();
                    while (iterator.hasNext()) {
                        Map column;
                        final Map map = column = (Map)iterator.next();
                        BizPortalSectionConfigJson configJson = new BizPortalSectionConfigJson(){
                            {
                                this.putAll(map);
                            }

                            @Override
                            public void setSrc(String src) {
                                super.setSrc(src);
                                map.put("src", src);
                            }

                            @Override
                            public void setId(Long id) {
                                super.setId(id);
                                map.put("id", id);
                            }

                            @Override
                            public void setElements(List<BizPortalSectionElement> elements) {
                                super.setElements(elements);
                                map.put("elements", elements);
                            }

                            @Override
                            public void setSourceId(Long sourceId) {
                                super.setSourceId(sourceId);
                                map.put("sourceId", sourceId);
                            }
                        };
                        sections.add(configJson);
                    }
                }
            }
        }
        return sections;
    }

    public void erasecolumnGroups() {
        List<Map<String, Object>> rows = this.getRows();
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (Map<String, Object> row : rows) {
            List cols = (List)row.get(COLS);
            if (!CollectionUtils.isNotEmpty((Collection)cols)) continue;
            for (Map col : cols) {
                col.put(COLUMN_GROUPS, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
        }
    }

    public void resetDataId(Map<String, String> mapping) {
        List<Map<String, Object>> rows = this.getRows();
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (Map<String, Object> row : rows) {
            List cols = (List)row.get(COLS);
            if (!CollectionUtils.isNotEmpty((Collection)cols)) continue;
            for (Map col : cols) {
                List columnGroups = (List)col.get(COLUMN_GROUPS);
                if (!CollectionUtils.isNotEmpty((Collection)columnGroups)) continue;
                for (Map columnGroup : columnGroups) {
                    List columns = (List)columnGroup.get(COLUMNS);
                    if (!CollectionUtils.isNotEmpty((Collection)columns)) continue;
                    for (Map column : columns) {
                        List elements = (List)column.get("elements");
                        if (!CollectionUtils.isNotEmpty((Collection)elements)) continue;
                        for (Map element : elements) {
                            String dataId = MapUtils.getString((Map)element, (Object)"dataId");
                            String newDataId = mapping.get(dataId);
                            if (newDataId == null) continue;
                            element.put("dataId", newDataId);
                        }
                    }
                }
            }
        }
    }

    private List<Map<String, Object>> getRows() {
        return (List)this.get(ROWS);
    }
}

