/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.bean;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.bean.BizPortalLayoutConfig;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionConfigJson;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BizPortalSpaceLayoutConfig
implements Serializable {
    private Long id;
    private Long layoutId;
    private Long themeId;
    private BizPortalLayoutConfig left;
    private BizPortalLayoutConfig right;
    private BizPortalLayoutConfig top;
    private BizPortalLayoutConfig bottom;
    private BizPortalLayoutConfig layout;
    private Map<Long, BizPortalSectionConfigJson> sectionMaps;
    private List<BizPortalSectionConfigJson> sections;

    public BizPortalSpaceLayoutConfig(CAPPortalSpaceConfig spaceConfig) {
        this.id = spaceConfig.getId();
        this.themeId = spaceConfig.getThemeId();
        this.layoutId = spaceConfig.getLayoutId();
        this.left = new BizPortalLayoutConfig(spaceConfig.getLeftLayout());
        this.right = new BizPortalLayoutConfig(spaceConfig.getRightLayout());
        this.top = new BizPortalLayoutConfig(spaceConfig.getTopLayout());
        this.bottom = new BizPortalLayoutConfig(spaceConfig.getBottomLayout());
        this.layout = new BizPortalLayoutConfig(spaceConfig.getLayout());
        HashMap temp = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        this.fillSections(this.left, temp, list);
        this.fillSections(this.right, temp, list);
        this.fillSections(this.top, temp, list);
        this.fillSections(this.bottom, temp, list);
        this.fillSections(this.layout, temp, list);
        this.sectionMaps = temp;
        this.sections = Collections.unmodifiableList(list);
    }

    private void fillSections(BizPortalLayoutConfig layoutConfig, Map<Long, BizPortalSectionConfigJson> sections, List<BizPortalSectionConfigJson> list) {
        for (BizPortalSectionConfigJson sectionConfigJson : layoutConfig.listSectionConfig()) {
            sections.put(sectionConfigJson.getId(), sectionConfigJson);
            list.add(sectionConfigJson);
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getLayoutId() {
        return this.layoutId;
    }

    public Long getThemeId() {
        return this.themeId;
    }

    public BizPortalLayoutConfig getLeft() {
        return this.left;
    }

    public BizPortalLayoutConfig getRight() {
        return this.right;
    }

    public BizPortalLayoutConfig getTop() {
        return this.top;
    }

    public BizPortalLayoutConfig getBottom() {
        return this.bottom;
    }

    public BizPortalLayoutConfig getLayout() {
        return this.layout;
    }

    public List<BizPortalSectionConfigJson> listSections() {
        return this.sections;
    }

    public BizPortalSectionConfigJson getSectionConfigJson(Long sectionId) {
        return this.sectionMaps.get(sectionId);
    }
}

