/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.controller;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.ReqUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class BizPortalController
extends BaseController {
    private BizPortalSpaceManager bizPortalSpaceManager;

    public ModelAndView editBizPortalSpace(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        Long spaceId = ReqUtil.getLong((HttpServletRequest)request, (String)"spaceId");
        CAPPortalSpace portalSpace = this.bizPortalSpaceManager.getCAPPortalSpace(spaceId);
        if (portalSpace == null) {
            throw new BusinessException("\u627e\u4e0d\u5230\u4e1a\u52a1\u7a7a\u95f4");
        }
        ContextParam contextParam = ContextParam.of(AppContext.getCurrentUser(), portalSpace.getBizId());
        CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.createEditBizPortalSpaceConfig(spaceId, contextParam);
        ModelAndView mav = new ModelAndView("cap4/form/bizportal/editBizPortalSpace");
        mav.addObject("bizId", (Object)portalSpace.getBizId());
        mav.addObject("spaceId", (Object)spaceId);
        mav.addObject("spaceName", (Object)portalSpace.getName());
        mav.addObject("configId", (Object)spaceConfig.getId());
        mav.addObject("platform", (Object)portalSpace.getPlatform());
        return mav;
    }

    public ModelAndView viewBizPortalSpace(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        Long spaceId = ReqUtil.getLong((HttpServletRequest)request, (String)"spaceId");
        CAPPortalSpace portalSpace = this.bizPortalSpaceManager.getCAPPortalSpace(spaceId);
        if (portalSpace == null) {
            throw new BusinessException("\u627e\u4e0d\u5230\u4e1a\u52a1\u7a7a\u95f4");
        }
        CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getBizPortalSpaceConfig(spaceId, BizPortalConstants.ConfigStatus.RUNNING);
        ModelAndView mav = new ModelAndView("cap4/form/bizportal/viewBizPortalSpace");
        mav.addObject("bizId", (Object)portalSpace.getBizId());
        mav.addObject("spaceId", (Object)spaceId);
        mav.addObject("spaceName", (Object)portalSpace.getName());
        mav.addObject("configId", (Object)spaceConfig.getId());
        mav.addObject("platform", (Object)portalSpace.getPlatform());
        return mav;
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }
}

