/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.dao;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.dao.BizPortalElementConfigDao;
import com.seeyon.cap4.bizportal.po.CAPPortalElementConfig;
import com.seeyon.ctp.util.DBAgent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class BizPortalElementConfigDaoImpl
implements BizPortalElementConfigDao {
    @Override
    public void saveCAPPortalElementConfig(List<CAPPortalElementConfig> elementConfigs) {
        if (CollectionUtils.isNotEmpty(elementConfigs)) {
            DBAgent.saveAll(elementConfigs);
        }
    }

    @Override
    public void updateCAPPortalElementConfig(List<CAPPortalElementConfig> elementConfigs) {
        if (CollectionUtils.isNotEmpty(elementConfigs)) {
            DBAgent.updateAll(elementConfigs);
        }
    }

    @Override
    public void removeCAPPortalElementConfig(List<CAPPortalElementConfig> elementConfigs) {
        DBAgent.deleteAll(elementConfigs);
    }

    @Override
    public List<CAPPortalElementConfig> findCAPPortalElementConfig(Long configId, Long sectionId, List<Long> elementIds) {
        String hql = "FROM CAPPortalElementConfig WHERE configId = :configId AND sectionId = :sectionId and elementId IN (:elementIds)";
        HashMap hqlParam = Maps.newHashMap();
        hqlParam.put("configId", configId);
        hqlParam.put("sectionId", sectionId);
        hqlParam.put("elementIds", elementIds);
        return DBAgent.find((String)hql, (Map)hqlParam);
    }

    @Override
    public List<CAPPortalElementConfig> findCAPPortalElementConfig(Long configId) {
        String hql = "FROM CAPPortalElementConfig WHERE configId = :configId and elementId is not null";
        HashMap hqlParam = Maps.newHashMap();
        hqlParam.put("configId", configId);
        return DBAgent.find((String)hql, (Map)hqlParam);
    }

    @Override
    public List<CAPPortalElementConfig> findCAPPortalElementConfigByDataId(List<String> dataIds) {
        return DBAgent.find((String)"FROM CAPPortalElementConfig where dataId in (:dataIds)", (Map)ImmutableMap.of((Object)"dataIds", dataIds));
    }
}

