/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.dao;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.dao.BizPortalFileDao;
import com.seeyon.cap4.bizportal.param.BizPortalFileListParam;
import com.seeyon.cap4.bizportal.po.CAPPortalFile;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.SQLWildcardUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BizPortalFileDaoImpl
implements BizPortalFileDao {
    @Override
    public void saveCAPPortalFile(CAPPortalFile portalFile) {
        DBAgent.save((Object)((Object)portalFile));
    }

    @Override
    public void updateCAPPortalFile(CAPPortalFile portalFile) {
        DBAgent.update((Object)((Object)portalFile));
    }

    @Override
    public FlipInfo findCAPPortalFile(Long memberId, BizPortalConstants.GoodsClassKey goodsClassKey, BizPortalFileListParam listParam, BizPortalConstants.Platform ... platforms) {
        StringBuilder hql = new StringBuilder("from CAPPortalFile where createMember=:createMember AND classType=:classType AND platform in(:platform) AND deleteFlag=false");
        HashMap hqlParam = Maps.newHashMap();
        hqlParam.put("createMember", memberId);
        hqlParam.put("classType", goodsClassKey.getKey());
        hqlParam.put("platform", this.convertToPlatformCodes(platforms));
        if (StringUtils.isNotEmpty((String)listParam.getName())) {
            hql.append(" and name LIKE :name ").append(SQLWildcardUtil.setEscapeCharacter());
            hqlParam.put("name", "%" + SQLWildcardUtil.escape((String)listParam.getName()) + "%");
        }
        FlipInfo flipInfo = new FlipInfo(listParam.getPage().intValue(), listParam.getPageSize().intValue());
        DBAgent.find((String)hql.toString(), (Map)hqlParam, (FlipInfo)flipInfo);
        return flipInfo;
    }

    @Override
    public FlipInfo findCAPPortalFileExcludeMember(Long memberId, BizPortalConstants.GoodsClassKey goodsClassKey, BizPortalFileListParam listParam, BizPortalConstants.Platform ... platforms) {
        StringBuilder hql = new StringBuilder("from CAPPortalFile where createMember!=:createMember AND classType=:classType AND platform in(:platform) AND deleteFlag=false");
        HashMap hqlParam = Maps.newHashMap();
        hqlParam.put("createMember", memberId);
        hqlParam.put("classType", goodsClassKey.getKey());
        hqlParam.put("platform", this.convertToPlatformCodes(platforms));
        if (StringUtils.isNotEmpty((String)listParam.getName())) {
            hql.append(" and name LIKE :name ").append(SQLWildcardUtil.setEscapeCharacter());
            hqlParam.put("name", "%" + SQLWildcardUtil.escape((String)listParam.getName()) + "%");
        }
        FlipInfo flipInfo = new FlipInfo(listParam.getPage().intValue(), listParam.getPageSize().intValue());
        DBAgent.find((String)hql.toString(), (Map)hqlParam, (FlipInfo)flipInfo);
        return flipInfo;
    }

    private List<Integer> convertToPlatformCodes(BizPortalConstants.Platform ... platform) {
        ArrayList list = Lists.newArrayList();
        for (BizPortalConstants.Platform p : platform) {
            list.add(p.getCode());
        }
        return list;
    }

    @Override
    public CAPPortalFile getCAPPortalFile(Long id) {
        return (CAPPortalFile)((Object)DBAgent.get(CAPPortalFile.class, (Serializable)id));
    }
}

