/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.dao;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.dao.BizPortalSpaceDao;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.SQLWildcardUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BizPortalSpaceDaoImpl
implements BizPortalSpaceDao {
    @Override
    public FlipInfo findCAPPortalSpaceByBizId(Long bizId, FlipInfo fi, Map<String, ?> params) {
        HashMap hqlParams = Maps.newHashMap();
        StringBuilder hql = new StringBuilder("from CAPPortalSpace where bizId = :bizId and deleteFlag=false ");
        hqlParams.put("bizId", bizId);
        if (params.containsKey("name")) {
            String name = MapUtils.getString(params, (Object)"name");
            hql.append(" and name LIKE :name ").append(SQLWildcardUtil.setEscapeCharacter());
            hqlParams.put("name", "%" + SQLWildcardUtil.escape((String)name) + "%");
        }
        if (params.containsKey("platform")) {
            hql.append(" and platform=:platform ");
            hqlParams.put("platform", params.get("platform"));
        }
        if (params.containsKey("state")) {
            hql.append(" and state=:state ");
            hqlParams.put("state", params.get("state"));
        }
        hql.append(" order by sort ");
        DBAgent.find((String)hql.toString(), (Map)hqlParams, (FlipInfo)fi);
        return fi;
    }

    @Override
    public CAPPortalSpace getCAPPortalSpace(Long spaceId) {
        return (CAPPortalSpace)((Object)DBAgent.get(CAPPortalSpace.class, (Serializable)spaceId));
    }

    @Override
    public void updateCAPPortalSpace(CAPPortalSpace portalSpace) {
        DBAgent.update((Object)((Object)portalSpace));
    }

    @Override
    public void saveCAPPortalSpace(CAPPortalSpace portalSpace) {
        DBAgent.save((Object)((Object)portalSpace));
    }

    @Override
    public List<CAPPortalSpace> findCAPPortalSpace(List<Long> spaceIds) {
        return DBAgent.find((String)"from CAPPortalSpace where id IN (:spaceIds)", (Map)ImmutableMap.of((Object)"spaceIds", spaceIds));
    }

    @Override
    public Integer getCAPPortalSpaceMaxSort(Long bizId) {
        List list = DBAgent.find((String)"select max(sort) from CAPPortalSpace where bizId = :bizId and deleteFlag=false", (Map)ImmutableMap.of((Object)"bizId", (Object)bizId));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (Integer)list.get(0);
    }

    @Override
    public void deleteCAPPortalSpace(List<CAPPortalSpace> list) {
        DBAgent.deleteAll(list);
    }
}

