/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource;

import com.seeyon.cap4.bizportal.datasource.AbstractDataSourceProviderImportAndExportable;
import com.seeyon.cap4.bizportal.datasource.MultiStepable;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.manager.BizPortalExternAdapterManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public abstract class DefaultDataSourceProvider
extends AbstractDataSourceProviderImportAndExportable
implements MultiStepable {
    protected BizPortalExternAdapterManager bizPortalExternAdapterManager;

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        this.addBizConfigNode(this.bizPortalExternAdapterManager.getBizConfigBean(contextParam.getBizId()), dataSetList);
        List<BizConfigBean> bizConfigBeans = this.bizPortalExternAdapterManager.findBizConfigBeanByOwner(contextParam.getUserId());
        for (BizConfigBean bizConfigBean : bizConfigBeans) {
            Long bizId = bizConfigBean.getId();
            if (ObjectUtils.equals((Object)bizId, (Object)contextParam.getBizId())) continue;
            dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(bizId), bizConfigBean.getName(), "0", new DataSetMetadata(this.uuid()).attr("id", bizId)));
        }
        return dataSetList;
    }

    private void addBizConfigNode(BizConfigBean bizConfigBean, DefaultDataSetList dataSetList) {
        Long bizId = bizConfigBean.getId();
        dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(bizId), bizConfigBean.getName(), "0", new DataSetMetadata(this.uuid()).attr("id", bizId)));
    }

    protected Long getMultiStepId(DataSetMetadata dataSetMetadata) {
        return dataSetMetadata.attrLong("id");
    }

    @Override
    public DefaultDataSetList.Node getStepNode(DataSetMetadata dataSetMetadata) throws BusinessException {
        Long bizId = this.getBizId(dataSetMetadata);
        DefaultDataSetList.Node node = new DefaultDataSetList.Node();
        node.setId(this.getNodeId(bizId));
        return node;
    }

    public void setBizPortalExternAdapterManager(BizPortalExternAdapterManager bizPortalExternAdapterManager) {
        this.bizPortalExternAdapterManager = bizPortalExternAdapterManager;
    }
}

