/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.bizmap;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.bizmap.BizMapDataSetResult;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.form.modules.bizmap.BizMapBo;
import com.seeyon.ctp.form.modules.bizmap.BizMapItemBo;
import com.seeyon.ctp.form.po.CtpBizMap;
import com.seeyon.ctp.form.util.Enums;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultBizMapDataSourceProvider
extends DefaultDataSourceProvider {
    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.BIZ_MAP;
    }

    public int getSortOrder() {
        return 0;
    }

    @Override
    public String uuid() {
        return "fe377d89-034e-4220-a13e-82137dd6158f";
    }

    @Override
    public String name() {
        return "\u4e1a\u52a1\u5bfc\u56fe";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        BizConfigBean configBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
        Long bizId = configBean.getId();
        DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(bizId.toString(), this.name());
        dataSetList.addNode(rootNode);
        List<CtpBizMap> list = this.bizPortalExternAdapterManager.findCtpBizMap(bizId);
        if (CollectionUtils.isNotEmpty(list)) {
            Iterator<CtpBizMap> it = list.iterator();
            while (it.hasNext()) {
                CtpBizMap bizMap = it.next();
                if (StringUtils.equals((String)Enums.LayoutType.PORTAL.getKey(), (String)bizMap.getLayoutType().toString())) continue;
                it.remove();
            }
            Function<String, String> fullNameFunction = this.getFullNameFunction(configBean);
            for (CtpBizMap cbm : list) {
                DataSetMetadata metadata = new DataSetMetadata(this.uuid()).attr("bizId", bizId).attr("mapId", cbm.getId());
                dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(cbm.getId()), cbm.getName(), (String)fullNameFunction.apply((Object)cbm.getName()), rootNode.getId(), metadata));
            }
        }
        return dataSetList;
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return this.bizPortalExternAdapterManager.checkBizMapAuth(this.attrRealLong(command, metadata, "mapId"), contextParam.getUser());
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        BizMapDataSetResult mapDataSetResult = new BizMapDataSetResult();
        BizMapBo bizMapBo = this.bizPortalExternAdapterManager.findBizMapAndItem(this.attrRealLong(command, metadata, "mapId"));
        if (bizMapBo != null) {
            String imageUrl = MessageFormat.format("{0}/fileUpload.do?method=showRTE&fileId={1}&type=image", SystemEnvironment.getContextPath(), bizMapBo.getAttId().toString());
            mapDataSetResult.setHref(imageUrl);
            List bizMapItems = bizMapBo.getBizMapItem();
            if (CollectionUtils.isNotEmpty((Collection)bizMapItems)) {
                ArrayList list = Lists.newArrayListWithCapacity((int)bizMapItems.size());
                for (BizMapItemBo bo : bizMapItems) {
                    BizMapDataSetResult.BizMapItem hotspot = new BizMapDataSetResult.BizMapItem();
                    hotspot.setPosition(bo.getPosition());
                    hotspot.setHref(bo.getUrl().startsWith("http") ? bo.getUrl() : SystemEnvironment.getContextPath() + bo.getUrl());
                    list.add(hotspot);
                }
                mapDataSetResult.setItems(list);
            }
        }
        return mapDataSetResult;
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        return metadata.attr("mapId", this.createBizPortalDataRelation(this.getBizId(metadata), dataId, metadata.attrLong("mapId")));
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "mapId").toString();
    }

    private Function<String, String> getFullNameFunction(final BizConfigBean configBean) {
        return new Function<String, String>(){

            public String apply(String bizMapName) {
                return configBean.getName() + "-" + bizMapName;
            }
        };
    }
}

