/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.indicator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.enums.ColQueryCondition;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultBizAndFormDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.indicator.IndicatorDataSetResult;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultFlowIndicatorDataSourceProvider
extends DefaultBizAndFormDataSourceProvider {
    private CollaborationApi collaborationApi;

    public int getSortOrder() {
        return -1;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.INDICATOR;
    }

    @Override
    public String uuid() {
        return "67947291-6b27-4371-8d64-4db3c695cb65";
    }

    @Override
    public String name() {
        return "\u6d41\u7a0b\u6307\u6807";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        if (StringUtils.equals((CharSequence)dataSetMetadata.getSign(), (CharSequence)String.valueOf(ApplicationCategoryEnum.cap4biz.getKey()))) {
            Long stepId = this.getMultiStepId(dataSetMetadata);
            DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(stepId.toString(), this.name());
            dataSetList.addNode(rootNode);
            BizConfigBean configBean = this.bizPortalExternAdapterManager.getBizConfigBean(stepId);
            Long bizId = configBean.getId();
            DefaultDataSetList.Node mergeNode = dataSetList.createBranchNode(bizId + "_FlowMerge", "\u6d41\u7a0b\u5408\u5e76", rootNode.getId());
            dataSetList.addNode(mergeNode);
            this.addFlowNode(configBean, "\u5f85\u529e\u5408\u8ba1\u6570", mergeNode, dataSetList, StateEnum.col_pending);
            this.addFlowNode(configBean, "\u5df2\u529e\u5408\u8ba1\u6570", mergeNode, dataSetList, StateEnum.col_done);
            this.addFlowNode(configBean, "\u5f85\u53d1\u5408\u8ba1\u6570", mergeNode, dataSetList, StateEnum.col_waitSend);
            this.addFlowNode(configBean, "\u5df2\u53d1\u5408\u8ba1\u6570", mergeNode, dataSetList, StateEnum.col_sent);
            List<FormBean> formBeans = this.bizPortalExternAdapterManager.findFormBeanByBizId(bizId);
            for (FormBean formBean : formBeans) {
                if (!this.bizPortalExternAdapterManager.isFlowBean(formBean)) continue;
                List<CtpTemplate> templates = this.bizPortalExternAdapterManager.findCtpTemplateByFormId(formBean.getId());
                for (CtpTemplate template : templates) {
                    DefaultDataSetList.Node templateNode = dataSetList.createBranchNode(template.getId().toString(), template.getSubject(), rootNode.getId());
                    dataSetList.addNode(templateNode);
                    this.addFlowNode(configBean, "\u5f85\u529e\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_pending, formBean.getId(), template);
                    this.addFlowNode(configBean, "\u5df2\u529e\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_done, formBean.getId(), template);
                    this.addFlowNode(configBean, "\u5f85\u53d1\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_waitSend, formBean.getId(), template);
                    this.addFlowNode(configBean, "\u5df2\u53d1\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_sent, formBean.getId(), template);
                }
            }
        } else {
            DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(String.valueOf(ApplicationCategoryEnum.cap4Form.getKey()), this.name());
            dataSetList.addNode(rootNode);
            List<FormBean> list = this.bizPortalExternAdapterManager.findFormBeanByOwner(contextParam.getUser());
            for (FormBean formBean : list) {
                if (!this.bizPortalExternAdapterManager.isFlowBean(formBean)) continue;
                List<CtpTemplate> templates = this.bizPortalExternAdapterManager.findCtpTemplateByFormId(formBean.getId());
                for (CtpTemplate template : templates) {
                    DefaultDataSetList.Node templateNode = dataSetList.createBranchNode(template.getId().toString(), template.getSubject(), rootNode.getId());
                    dataSetList.addNode(templateNode);
                    this.addFlowNode("\u5f85\u529e\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_pending, formBean, template);
                    this.addFlowNode("\u5df2\u529e\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_done, formBean, template);
                    this.addFlowNode("\u5f85\u53d1\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_waitSend, formBean, template);
                    this.addFlowNode("\u5df2\u53d1\u5408\u8ba1\u6570", templateNode.getId(), dataSetList, StateEnum.col_sent, formBean, template);
                }
            }
        }
        return dataSetList;
    }

    private void addFlowNode(String name, String parentId, DefaultDataSetList dataSetList, StateEnum state, FormBean formBean, CtpTemplate template) {
        Long templateId = template.getId();
        int key = state.getKey();
        DataSetMetadata metadata = new DataSetMetadata(this.uuid()).attr("code", ApplicationCategoryEnum.cap4Form.getKey()).attr("formId", formBean.getId()).attr("templateId", templateId).attr("state", key);
        DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(this.getFlowNodeKey(templateId, key)), name, "\u8868\u5355\u7ba1\u7406-" + template.getSubject() + "-" + name, template.getSubject() + "(" + name + ")", parentId, metadata);
        dataSetList.addNode(leafNode);
    }

    private void addFlowNode(BizConfigBean bizConfigBean, String name, String parentId, DefaultDataSetList dataSetList, StateEnum state, Long formId, CtpTemplate template) {
        Long templateId = template.getId();
        int key = state.getKey();
        DataSetMetadata metadata = new DataSetMetadata(this.uuid()).attr("code", ApplicationCategoryEnum.cap4biz.getKey()).attr("bizId", bizConfigBean.getId()).attr("formId", formId).attr("templateId", templateId).attr("state", key);
        DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(this.getFlowNodeKey(templateId, key)), name, bizConfigBean.getName() + "-" + template.getSubject() + "-" + name, template.getSubject() + "(" + name + ")", parentId, metadata);
        dataSetList.addNode(leafNode);
    }

    private void addFlowNode(BizConfigBean bizConfigBean, String name, DefaultDataSetList.Node parentNode, DefaultDataSetList dataSetList, StateEnum state) {
        int key = state.getKey();
        Long bizId = bizConfigBean.getId();
        DataSetMetadata metadata = new DataSetMetadata(this.uuid()).attr("code", ApplicationCategoryEnum.cap4biz.getKey()).attr("bizId", bizId).attr("state", key);
        DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(this.getFlowNodeKey(bizId, key)), name, bizConfigBean.getName() + "-" + parentNode.getName() + "-" + name, bizConfigBean.getName() + "(" + name + ")", parentNode.getId(), metadata);
        dataSetList.addNode(leafNode);
    }

    private String getFlowNodeKey(Long entityId, Integer state) {
        return entityId + "_" + state;
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return true;
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        String templateIdStr;
        if (ObjectUtils.equals((Object)this.getCategoryEnum(metadata), (Object)ApplicationCategoryEnum.cap4biz)) {
            Long bizId = this.getBizId(metadata);
            Long templateId = this.attrRealLong(command, metadata, "templateId");
            if (templateId == null) {
                ArrayList templateIds = Lists.newArrayList();
                List<FormBean> formBeans = this.bizPortalExternAdapterManager.findFormBeanByBizId(bizId);
                for (FormBean formBean : formBeans) {
                    if (!this.bizPortalExternAdapterManager.isFlowBean(formBean)) continue;
                    List<CtpTemplate> templates = this.bizPortalExternAdapterManager.findCtpTemplateByFormId(formBean.getId());
                    for (CtpTemplate template : templates) {
                        templateIds.add(template.getId());
                    }
                }
                templateIdStr = StringUtils.join((Iterable)templateIds, (String)",");
            } else {
                templateIdStr = templateId.toString();
            }
        } else {
            templateIdStr = metadata.attrLong("templateId").toString();
        }
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)templateIdStr)) {
            HashMap queryParam = Maps.newHashMap();
            queryParam.put(ColQueryCondition.templeteIds.name(), templateIdStr);
            queryParam.put(ColQueryCondition.currentUser.name(), contextParam.getUserId().toString());
            queryParam.put(ColQueryCondition.state.name(), metadata.attr("state").toString());
            count = this.collaborationApi.getColAffairsCountByCondition((Map)queryParam);
        }
        IndicatorDataSetResult dataSetResult = new IndicatorDataSetResult();
        dataSetResult.setFieldType(Enums.FieldType.DECIMAL.getKey());
        dataSetResult.setSource(count);
        dataSetResult.setValue(count);
        return dataSetResult;
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        if (ObjectUtils.equals((Object)this.getCategoryEnum(metadata), (Object)ApplicationCategoryEnum.cap4biz)) {
            Long templateId;
            Long bizId = this.getBizId(metadata);
            Long formId = metadata.attrLong("formId");
            if (formId != null) {
                metadata.attr("formId", this.createBizPortalDataRelation(bizId, dataId, formId));
            }
            if ((templateId = metadata.attrLong("templateId")) != null) {
                metadata.attr("templateId", this.createBizPortalDataRelation(bizId, dataId, templateId));
            }
        }
        return metadata;
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        if (ObjectUtils.equals((Object)this.getCategoryEnum(metadata), (Object)ApplicationCategoryEnum.cap4biz)) {
            Long bizId = this.getBizId(metadata);
            Long templateId = this.attrRealLong(command, metadata, "templateId");
            if (templateId == null) {
                return this.getFlowNodeKey(bizId, metadata.attrInt("state"));
            }
            return this.getFlowNodeKey(templateId, metadata.attrInt("state"));
        }
        Long templateId = this.attrRealLong(command, metadata, "templateId");
        return this.getFlowNodeKey(templateId, metadata.attrInt("state"));
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }
}

